import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'app-application-fee-order',
  templateUrl: './order.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class OrderApplicationFeeComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();

  constructor(
    private _router: Router,
    private _activatedRoute: ActivatedRoute,
  ) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/services/university/applicationFee/' +
          this._activatedRoute.snapshot.params['language']
      );  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
