import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { HostelFeeComponent } from './dormitoryFee.component';
const routes: Routes = [
  {
    path: '',
    component: HostelFeeComponent,
    data: {
      breadcrumb: [
        {
          title: 'هزینه خوابگاه',
          url: '/dashboard/services/university/dormitoryFee',
          isBlock: true,
        },
      ],
    },
    children: [
      {
        path: ':company',

        loadChildren: () =>
          import('./order/order.module').then((m) => m.OrderHostelFeeModule),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class HostelFeeRoutingModule {}
