import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { scrollTop } from '@helpers/window.helper';
import { StyleStore } from '@stores/style.store';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: "University",
  templateUrl: "./university.component.html",
  styleUrls: ["./university.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})

export class UniversityComponent
  implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  url = window.location.href;
  orderType: string;

  constructor(private _styleStore: StyleStore,
    private cdr: ChangeDetectorRef,
    public _activatedroute: ActivatedRoute,

  ) { }

  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false
    });

  }

  ngAfterViewInit() { }

  onActivate(event) {
    scrollTop();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}