import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
  HostListener,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ApplicationFeePriceModel } from '@models/orders/ApplicationFeePriceModel';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { ApplicationFeeSaveModel } from 'src/app/core/params/order/ApplicationFeeSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { FileUploadService } from '@services/fileUpload.service';
import { isUrlValid } from '@helpers/validator.helper';
import { LegalOrderComponent } from '../../../components/legal-order/legal-order.component';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { LegalOrderModel } from 'src/app/core/params/order/LegalOrderModel';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { ViewportScroller } from '@angular/common';
import { DialogService } from 'primeng/dynamicdialog';

import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { CompanyInfoGet } from '@models/user/companyInfoModel';

@Component({
  selector: 'app-university-tuition-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrderUniversityTuitionComponent implements OnInit, OnDestroy {
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  legalOrder: LegalOrderModel = new LegalOrderModel();
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;

  data: UserProfile;
  timeout = null;
  isValidLegalForm: boolean = true;
  dataPrice: ApplicationFeePriceModel;
  model: ApplicationFeeSaveModel = new ApplicationFeeSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  applicationFeeType: string;
  progress: number = 0;
  isDesktop: boolean;
  totalQuestionRecord: number = 0;
  orderType: string;
  currentRoute: string;
  keyValues: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  imageId: string;
  isOnline: boolean = false;
  activeIndex: number = 0;
  companyInfo = new CompanyInfoGet();
  orderOptions = [
    { value: 'swift', title: 'حواله سوئیفت' },
    { value: 'dormitory-fee', title: 'پرداخت آنلاین' },
  ];
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private viewportScroller: ViewportScroller,
    public dialogService: DialogService,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  dataUser: UserProfile;
  errMsg: any;

  routeTo() {
    if (this.currentRoute == 'swift') {
      this.isOnline = false;
      this._alert.info(
        'کاربر گرامی شما برای پرداخت شهریه دانشگاه بوسیله حواله سوئیفت، به صفحه این سفارش منتقل می شوید، لطفا اطلاعات موردنیاز را وارد نمایید.'
      );
      this._router.navigateByUrl('/dashboard/services/swift');
      return;
    }
    if (this.currentRoute == 'tuition') {
      this.isOnline = true;
    }

    this.getFullOrder();
  }

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.routeTo();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.model.fileId = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: 175,
            sort: 'sortNumber asc',
            pageSize: 50,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }
              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.applicationFeeType = '2';
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();

      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    }
  }

  submit() {
    if (!isUrlValid(this.model.address)) {
      this._alert.warning('لطفا آدرس صفحه ورود را بدرستی وارد نمایید');
      return;
    }

    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.companyId = this.companyInfo.companyId;
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.ApplicationFeeSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success('ثبت پیش فاکتور با موفقیت انجام شد');
            this._router.navigateByUrl(
              '/dashboard/checkouts/university-tuition/' +
                response.data.orderId +
                '/' +
                this.model.companyId
            );
          },
          (error) => {
            this.errMsg = error.status;
            setTimeout(() => {
              this.orderVerify.modalGetMobile();
            }, 200);
          }
        )
    );
  }
  public anchorScroll(elementId: string): void {
    this.viewportScroller.scrollToAnchor(elementId);
  }

  scrollToElement($element): void {
    $element.scrollIntoView({
      behavior: 'smooth',
      block: 'start',
      inline: 'nearest',
    });
  }
}
