import { RouterModule, Routes } from '@angular/router';
import { TicketsComponent } from './tickets.component';
import { NgModule } from '@angular/core';

const routes: Routes = [
  {
    path: '',
    component: TicketsComponent,
    data: { breadcrumb: [{ title: 'تیکت ها', url: '/dashboard/tickets' }] },
  },
 
  {
    path: 'newticket',
    data: {
      title: 'ارسال تیکت جدید',
      breadcrumb: [{ title: 'تیکت ها', url: '/dashboard/tickets' }],
    },
    loadChildren: () =>
      import('./newTicket/newTicket.module').then((m) => m.NewTicketsModule),
  },
 
  {
    path: 'showticket/:id',
    data: {
      title: 'مشاهده تیکت',
      breadcrumb: [{ title: 'تیکت ها', url: '/dashboard/tickets' }],
    },
    loadChildren: () =>
      import('./showTicket/showTicket.module').then((m) => m.ShowTicketsModule),
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class TicketsRoutingModule {}
