import { AfterViewInit, ChangeDetectionStrategy, ChangeDetectorRef, Component, ElementRef, OnDestroy, OnInit, ViewChild } from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { finalize } from 'rxjs/operators';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { Subscription } from 'rxjs';
import { TranslateService } from '@ngx-translate/core';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { setAutoFocous } from '@helpers/window.helper';
@Component({
    selector: 'addBankAccount',
    templateUrl: 'addBankAccount.component.html',
    changeDetection: ChangeDetectionStrategy.OnPush,
    animations: [fadeAnimation],
    host: { '[@fadeInAnimation]': '' }
})
export class AddBankAccountComponent implements OnInit, OnDestroy, AfterViewInit {
    @ViewChild('account') input: ElementRef;

    constructor(
        private _commonService: CommonService,
        public ref: DynamicDialogRef,
        public config: DynamicDialogConfig,
        private cdr: ChangeDetectorRef,
        private _translate: TranslateService,


    ) {
    }
    limitForAddBankingCardSecond: string;
    subscriptions = new Subscription();
    isLoading: boolean = false;
    cardNumber: string;
    ngOnInit() {

        setAutoFocous('p-inputtext');

        this._translate.get('limitForAddBankingCardSecond').subscribe(response => {
            this.limitForAddBankingCardSecond = response;
        })
    }
    ngAfterViewInit() {

    }

    submit() {
        this.isLoading = true;
        this.cdr.detectChanges();
        this.subscriptions.add(
            this._commonService
                .post(Address.BankAccountSave, { cardNumber: this.cardNumber }).pipe(finalize(() => {
                    this.isLoading = false;
                    this.cdr.detectChanges();
                }))
                .subscribe(
                    (res) => {
                        if (res) {
                            this.ref.close(res.data);
                            this.cdr.detectChanges();
                        }
                    }
                )

        );

    }

    close() {
        this.ref.close(null);
        this.cdr.detectChanges();
    }

    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }

    focus() {

    }
}
