import { Component, OnInit, ViewChild } from '@angular/core';
import { CaptchaComponent } from '@components/captcha/captcha.component';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { response } from '@interfaces/response';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { DynamicDialogRef } from 'primeng/dynamicdialog';
import { Subscription } from 'rxjs';
import { finalize } from 'rxjs/operators';

@Component({
  selector: 'modal-chanage-password',
  templateUrl: 'changePasswordModal.component.html',
})
export class ModalChangePasswordComponent implements OnInit {
  @ViewChild('captcha') captchA: CaptchaComponent;

  data: UserProfile;

  isSentPassword: boolean = false;

  isLoading: boolean = false;
  isNullCaptcha: boolean;
  subscriptions = new Subscription();
  constructor(
    private _userStore: UserStore,
    public ref: DynamicDialogRef,
    private _commonService: CommonService,
    private _messageService: AlertHelper
  ) {}
  ngOnInit() {
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.data = res;
      }
    });
  }

  close() {
    this.ref.close();
  }
  getSubmitMethod(): any {
    return {
      callSubmitMethod: () => {
        this.submit();
      },
    };
  }
  submit() {
    if (
      this.captchA.captchaInfo &&
      (this.captchA.captchaInfo.captchaCode != null ||
        this.captchA.captchaInfo.captchaCode != '')
    ) {
      this.isLoading = true;

      this.subscriptions.add(
        this._commonService
          .put(Address.CaptchaChangePassword, {
            captchaCode: this.captchA.captchaInfo.captchaCode,
            captchaId: this.captchA.captchaInfo.captchaId,
          })
          .pipe(
            finalize(() => {
              this.isLoading = false;
            })
          )
          .subscribe(
            (response: response) => {
              this.isSentPassword = true;
            },
            (error) => {}
          )
      );
    } else {
      this._messageService.error('لظفا کدامنیتی را وارد کنید.');
    }
  }
}
