import { AlertHelper } from './../../../core/helpers/alert.helper';
import { stringIsEmptyOrNull } from './../../../core/helpers/validator.helper';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
  Output,
  ViewChild,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import {
  CountdownConfig,
  CountdownComponent,
  CountdownEvent,
} from 'ngx-countdown';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { VerifyModel } from 'src/app/core/params/auth/verifyMode';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { toEnglishDigits } from '@helpers/convertToEnglishDigit.helper';
import { AuthStore } from '@stores/AuthSetting.store';
import { CaptchaComponent } from '@components/captcha/captcha.component';
@Component({
  selector: 'app-landline-verification',
  templateUrl: './landline-verification.component.html',
  styleUrls: ['./landline-verification.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class LandlineVerificationComponent
  implements OnInit, OnChanges, OnDestroy
{
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private _userStore: UserStore,
    private _authSettingStore: AuthStore,
    private cdr: ChangeDetectorRef
  ) {
    this._authSettingStore.isActiveCaptcha.subscribe((res) => {
      if (res != null) {
        this.isActiveCaptcha = res;
      }
    });

    this._authSettingStore.isActiveCaptchaBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveCaptcha = res;
      }
    });
  }
  @ViewChild('captcha') captcha: CaptchaComponent;
  isActiveCaptcha: boolean;
  @Output() onSave = new EventEmitter();
  isShowOtp = false;
  tel: string = null;
  otp: string = null;
  isLoadingGet: boolean = false;
  model: VerifyModel = new VerifyModel();
  isLoading: boolean = false;
  isLoadingResendCode: boolean = false;
  isLoadingVerify: boolean = false;
  canResend: boolean = true;
  isEditting: boolean = false;
  telOld:string;

  @Input() data: UserProfile = null;
  setInterval = setInterval;

  subscriptions = new Subscription();
  @ViewChild('cd', { static: false }) private countdown: CountdownComponent;
  config: CountdownConfig = {
    leftTime: 0,
    format: 'm:s',
  };
  setNewTimer() {
    this.config = {
      leftTime: 120,
      format: 'm:s',
    };
    this.canResend = false;
        this.cdr.detectChanges();
  }

  finishTimer(e: CountdownEvent) {
    if (e.action == 'done') {
      this.canResend = true;
            this.captcha.handleRefreshCaptcha();
          this.cdr.detectChanges();
    }
  }

  ngOnInit(): void {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if (this.data != undefined && this.data != null) {
      this.tel = this.data.tel;
      this.canResend = false;
          this.cdr.detectChanges();
    }
  }
  ngAfterViewInit() {}
  userGetInfo() {
    this.isLoadingGet = true;
        this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
                this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
            this.tel = this.data.tel;
            this._userStore.user.next(response.data);
            this._userStore.userBehavior.next(response.data);
                this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  verify() {
    if (stringIsEmptyOrNull(this.otp)) {
      this._alert.warning('لطفا کد یکبار مصرف را وارد کنید');
      return;
    }
    this.isLoadingVerify = true;
        this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          Address.VerifyInPanel,
          {
            code: this.otp,
            typeVerify: 103,
            tokenVerify: this.model.token,
            address: this.model.address,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingVerify = false;
                this.cdr.detectChanges();
          })
        )
        .subscribe((response: response) => {
          this.isShowOtp = false;
          this.canResend = true;
          this.data.tel = this.tel;
          this.isEditting = false;
          this.onSave.emit(true);
          this._alert.success('شماره ثابت شما با موفقیت تایید شد');
              this.cdr.detectChanges();
          this.userGetInfo();
        })
    );
  }

  editInfo() {
    this.telOld = this.tel;
    this.isEditting = true;
    this.data.tel = '';
    this.canResend = true;
        this.cdr.detectChanges();
  }

    cancel() {
    this.isEditting = false;
    this.canResend = false;
    this.isShowOtp = false;
    this.tel   = this.telOld;
    this.data.tel = this.telOld;
    this.cdr.detectChanges();
  }

  submit() {
    if (stringIsEmptyOrNull(this.tel)) {
      this._alert.warning('لطفا تلفن ثابت را وارد کنید');
      return;
    }
    if (
      this.isActiveCaptcha &&
      (!this.captcha.CaptchaCode ||
        stringIsEmptyOrNull(this.captcha.CaptchaCode.value))
    ) {
      this._alert.warning('لطفا کد امنیتی را وارد کنید');
      return;
    }
    this.tel = toEnglishDigits(this.tel);
    this.isLoading = true;
        this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(
          Address.SendInPanel,
          {
            address: String(this.tel),
            typeVerify: 103,
            sendCodeLandlineNumber: true,
            captchaCode: this.captcha.captchaInfo.captchaCode,
            captchaId: this.captcha.captchaInfo.captchaId,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
                this.cdr.detectChanges();
          })
        )
        .subscribe((response: response) => {
          setTimeout(() => {
            this.setNewTimer();
          }, 1000);
          this.isShowOtp = true;
          this.model.token = response.data.token;
          this.model.typeVerify = response.data.typeVerify;
          this.model.address = response.data.address;
          this._alert.success('کد یکبار مصرف برای شما ارسال شد');
              this.cdr.detectChanges();
        },(err)=>{
                     this.captcha.handleRefreshCaptcha();
        })
    );
  }
}
