import { AlertHelper } from './../../../core/helpers/alert.helper';
import { VerifyingModel } from './../../../core/models/user/VerifyingModel';
import { CommonService } from '@services/common.service';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { finalize, Subscription } from 'rxjs';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { FileUploadService } from '@services/fileUpload.service';
import { response } from '@interfaces/response';
import { TranslateService } from '@ngx-translate/core';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
@Component({
  selector: 'uploader-selfiImage',
  templateUrl: 'uploaderSelfiImage.component.html',
  styleUrls: ['uploaderSelfiImage.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class UploaderSelfiImageComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    private _alert: AlertHelper,
    private _translate: TranslateService
  ) { }
  progress: number = 0;
  subscriptions = new Subscription();
  file: File;
  showRole: boolean = false;
  @Input() id: string = null;
  @Input() name: string = null;
  @Input() family: string = null;
  @Input() nationalCode: string = null;
  @Input() extension: string = null;
  @Input() verifyingData: VerifyingModel[] = null;
  extensionStore: string;
  @Input() url: string = null;
  isLoading: boolean = false;
  isLoadingGet: boolean = false;
  canNotUpload: boolean = false;
  isAcceptSelfie: boolean = false;
  isAcceptCard: boolean = false;
  isExistsSelfi: boolean = false;
  isLoadingSubmit: boolean = false;
  isShowSave: boolean = false;
  checkedRole: boolean = false;
  textError: string;
  messageAlarmTimeToAccept: string;
  isnotValidRules: boolean = false;

  async ngOnInit() {
    this._translate.get('timeForAcceptDocuments').subscribe((response) => {
      this.messageAlarmTimeToAccept = response;
    });
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if (this.verifyingData != null && this.verifyingData.length > 0) {
      for (let item of this.verifyingData) {
        if (item.typeVerifying == 116) {
          this.isExistsSelfi = true;
          this.textError = item.text;
          this.isAcceptSelfie = item.isAccept;
          if (this.isAcceptSelfie == true && !stringIsEmptyOrNull(this.id)) {
            this.checkedRole = true;
            this.canNotUpload = true;
            this.loadFiles(this.id);
          } else if (
            !this.isAcceptSelfie &&
            !stringIsEmptyOrNull(item.imageId) &&
            stringIsEmptyOrNull(this.url) &&
            stringIsEmptyOrNull(item.text)
          ) {
            this.canNotUpload = true;
            this.checkedRole = false;
            this.loadFiles(item.imageId);
          }
        }
      }
    }
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList != null && fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  fileUpload() {
    this.isLoading = true;
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBigFileImage)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.id = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoading = false;
                this.isShowSave = true;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  addDocument() {
    if (!this.checkedRole) {
      this._alert.warning(
        'لطفا متن تعهد نامه بالا را مطالعه نمایید و پس از تأیید روی دکمه ثبت کلیک کنید.'
      );
    } else if (this.checkedRole) {
      this.isLoadingSubmit = true;
      this.subscriptions.add(
        this._commonService
          .post(Address.DocumentSave, {
            fileId: this.id,
            documentType: 139,
            title: 'تصویر سلفی به همراه تعهد نامه',
          })
          .pipe(
            finalize(() => {
              this.isLoadingSubmit = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              this.canNotUpload = true;
              this.isShowSave = false;
              this.isExistsSelfi = true;
              this._alert.success(
                'تصویر  تعهد نامه از جانب شما دریافت شده و نتیجه پس از بررسی توسط کارشناسان به شما اطلاع داده خواهد شد'
              );
              this.userGetVerifying();
              this.cdr.detectChanges();
            },
            (err: any) => { },
            () => { }
          )
      );
    }
  }

  loadFiles(id: string) {
    if (stringIsEmptyOrNull(this.url) && !stringIsEmptyOrNull(id)) {
      this.isLoadingGet = true;
      this.subscriptions.add(
        this._commonService
          .getResponseText(Address.GetFileUrl + id)
          .pipe(
            finalize(() => {
              this.isLoadingGet = false;
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response) => {
              this.url = response;

              if (!stringIsEmptyOrNull(this.url))
                this.extensionStore = String(
                  this.url.substring(
                    this.url.lastIndexOf('.') + 1,
                    this.url.length
                  )
                ).toLowerCase();
            },
            (err: any) => { },
            () => { }
          )
      );
    }

  }

  userGetVerifying() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(finalize(() => { }))
        .subscribe(
          (response: response) => {
            this.verifyingData = response.data;
            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }

  alarmForSelfiRules(checkedRole) {
    if (checkedRole == false) {
      this.isnotValidRules = true;
      setTimeout(() => {
        this.isnotValidRules = false;
      }, 500);
    }
  }
}
