import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { CommonService } from '@services/common.service';
import { Location } from '@angular/common';
import { cloneDeep } from 'lodash-es';
import { Message } from 'primeng/api';
import { Subscription, finalize } from 'rxjs';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { TableLazyLoadEvent } from 'primeng/table';
import { PagingHelper } from '@helpers/paging.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { UserStore } from '@stores/user.store';
import { ICashExchange } from '@interfaces/orders/iCashExchange';

@Component({
  selector: 'user-applications',
  templateUrl: './userApplications.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class UserApplicationsComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public _activatedroute: ActivatedRoute,
    public _pagingHelper: PagingHelper,
    public location: Location,
    private _userStore: UserStore
  ) { }

  subscriptions = new Subscription();
  messages: Message[] = [];
  filter: any = {};
  cashExchangeApplications: ICashExchange[] = [];
  isLoading: boolean = true;
  query: BaseParams;
  totalRecords: number = 0;
  search: OrderSearchModel = new OrderSearchModel();
  dataUser: UserProfile = new UserProfile();
  walletId: string;
  message: string = MessageStatic.NotFound;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  isLoadingActivate: boolean;
  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }

  ngOnInit(): void {
    this.query = new BaseParams();
    this._userStore.getUser().subscribe((res) => {
      this.walletId = res.walletId;
    
      this.cdr.detectChanges();
    });

    this.getUserStore();
    this.cdr.detectChanges();
  }
  getUserStore() {

    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.walletId = res.walletId;
        
      }
    });
  }


  goBackToPrevPage() {
    this.location.back();
  }

  getData(event: TableLazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);

    this.subscriptions.add(
      this._commonService
        .put(Address.cashApplicationGetAll, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.cashExchangeApplications = cloneDeep(res.data);

            this.totalRecords = res.actualSize;
            this.cdr.detectChanges();
          }
        })
    );
  }
}
