import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { UserComponent } from './user.component';
import { UserLevelComponent } from './user-level/userLevel.component';
import { AddUserComponent } from './add-user/addUser.component';
import { AddUserModalComponent } from './add-user/addUserModal/addUserModal.component';

const routes: Routes = [
  {
    path: '',
    
    component: UserComponent,
    data:{breadcrumb: 'اطلاعات هویتی' },
  },
  {
    path: 'user-level/:company',
    component: UserLevelComponent,
    data:{breadcrumb: 'سطوح کاربری' },
  },
  {
    path: 'users-list/:company',
    component: AddUserComponent,
    data:{breadcrumb: 'لیست کاربران' },
  },
  {
    path: 'add-user/:company',
    component: AddUserModalComponent,
    data:{breadcrumb: 'افزودن کاربر جدید' },
  }
 
 
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class UserRoutingModule { }
