import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  Component,
  OnDestroy,
  OnInit,
  OnChanges,
  ChangeDetectorRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { DocumentsModel } from '@models/user/DocumentsModel';
import { ActivatedRoute, Router, NavigationStart } from '@angular/router';
import { IBankAccount } from '@interfaces/user/IBankAccount';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { StyleStore } from '@stores/style.store';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { WalletModelGet } from '@models/user/WalletModelGet';
import { cloneDeep } from 'lodash-es';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { Location } from '@angular/common';
import { FileUploadService } from '@services/fileUpload.service';
import { GetSettingAuth } from '@models/auth/authSettingGetModel';
import { AuthStore } from '@stores/AuthSetting.store';
@Component({
  selector: 'app-user',
  templateUrl: './user.component.html',
  styleUrls: ['./user.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class UserComponent implements OnInit, OnDestroy, OnChanges {
  activeIndex: number = 0;
  indexTab: number = 0;
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetDocument: boolean = false;
  isLoadingGetBankAccount: boolean = false;

  dataVerifying: VerifyingModel[] = [];
  data: UserProfile;
  documents: DocumentsModel[] = null;
  bankAccount: IBankAccount[] = [];
  nationalCardId: string = null;
  selfiImageId: string = null;
  isCompeleteBaseInformation: boolean = false;
  isCompeleteTel: boolean = false;
  isCompeleteEmail: boolean = false;
  isCompleteMobile: boolean = false;
  isCompeleteBanking: boolean = false;
  isCompeleteDocumentSelfi: boolean = false;
  isCompeleteDocumentNationalCard: boolean = false;
  query: BaseParams;
  walletTransactions: WalletModelGet[] = [];
  totalRecords: number = 0;
  isLoadingGetWallet: boolean;
  companyId: string;
  isLoadingGetCompany: boolean;
  companyInfo = new CompanyInfoGet();
  userInfo: UserProfile = new UserProfile();
  isGetAuthSetting: boolean = false;
  settingAuth: GetSettingAuth = new GetSettingAuth();
  constructor(
    private _commonService: CommonService,
    private _userStore: UserStore,
    private _activatedRoute: ActivatedRoute,
    private _router: Router,
    private _styleStore: StyleStore,
    private _companyInfoStore: CompanyInfoStore,
    private cdr: ChangeDetectorRef,
    public location: Location,
    private _authSettingStore: AuthStore,
    private _fileUploadService: FileUploadService
  ) {
    this.companyId = this._activatedRoute.snapshot.params['company'];
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[3] != undefined &&
          event.url.split('/')[3] != null &&
          event.url.split('/')[3] != ''
        ) {
          this.handleChangeRoute(
            event.url.split('/')[3] + '/' + this.companyId
          );
        }
      }
    });

    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });

    this._userStore.user.subscribe((res) => {
      if (res != null) {
        this.userInfo = res;
      }
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.userInfo = res;
      }
    });
  }
  goBackToPrevPage() {
    this.location.back();
  }
  ngOnChanges() {}

  getAuthSetting() {
    this.isGetAuthSetting = true;
    this.subscriptions.add(
      this._commonService
        .get(Address.AuthSettingGet)
        .pipe(
          finalize(() => {
            this.isGetAuthSetting = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.settingAuth = response.data;
            this._authSettingStore.isActiveCaptcha.next(
              this.settingAuth.isActiveCaptcha
            );
            this._authSettingStore.isActiveCaptchaBehavior.next(
              this.settingAuth.isActiveCaptcha
            );

            this._authSettingStore.isActiveOAuth.next(
              this.settingAuth.isActiveOAuth
            );
            this._authSettingStore.isActiveOAuthBehavior.next(
              this.settingAuth.isActiveOAuth
            );

            this._authSettingStore.isActiveWhatsapp.next(
              this.settingAuth.isActiveWhatsapp
            );
            this._authSettingStore.isActiveWhatsappBehavior.next(
              this.settingAuth.isActiveWhatsapp
            );

            this._authSettingStore.isActiveAuthenticationMobile.next(
              this.settingAuth.isActiveAuthenticationMobile
            );
            this._authSettingStore.isActiveAuthenticationMobileBehavior.next(
              this.settingAuth.isActiveAuthenticationMobile
            );

            this._authSettingStore.isActiveSms.next(
              this.settingAuth.isActiveSms
            );
            this._authSettingStore.isActiveSmsBehavior.next(
              this.settingAuth.isActiveSms
            );

            this._authSettingStore.isActiveAuthenticationEmail.next(
              this.settingAuth.isActiveAuthenticationEmail
            );
            this._authSettingStore.isActiveAuthenticationEmailBehavior.next(
              this.settingAuth.isActiveAuthenticationEmail
            );

            this._authSettingStore.isActiveEmail.next(
              this.settingAuth.isActiveEmail
            );
            this._authSettingStore.isActiveEmailBehavior.next(
              this.settingAuth.isActiveEmail
            );

            this._authSettingStore.isActiveTTS.next(
              this.settingAuth.isActiveTTS
            );
            this._authSettingStore.isActiveTTSBehavior.next(
              this.settingAuth.isActiveTTS
            );

            this._authSettingStore.parallelSendingWhatsappLogin.next(
              this.settingAuth.parallelSendingWhatsappLogin
            );
            this._authSettingStore.parallelSendingWhatsappLoginBehavior.next(
              this.settingAuth.parallelSendingWhatsappLogin
            );

            this._authSettingStore.isActiveRecaptcha.next(
              this.settingAuth.isActiveGoogleRecaptcha
            );
            this._authSettingStore.isActiveRecaptchahBehavior.next(
              this.settingAuth.isActiveGoogleRecaptcha
            );

            this._authSettingStore.isActiveBotTelegram.next(
              this.settingAuth.isActiveBotTelegram
            );
            this._authSettingStore.isActiveBotTelegramBehavior.next(
              this.settingAuth.isActiveBotTelegram
            );

            this._authSettingStore.parallelSendingTelegramLogin.next(
              this.settingAuth.parallelSendingTelegramLogin
            );
            this._authSettingStore.parallelSendingTelegramLoginBehavior.next(
              this.settingAuth.parallelSendingTelegramLogin
            );

            this._authSettingStore.userNameBotTelegram.next(
              this.settingAuth.userNameBotTelegram
            );
            this._authSettingStore.userNameBotTelegramBehavior.next(
              this.settingAuth.userNameBotTelegram
            );
          },
          (error) => {}
        )
    );
  }

  ngOnInit(): void {
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });
    if (
      this._activatedRoute.snapshot.params['active'] &&
      this._activatedRoute.snapshot.params['company']
    ) {
      this.companyId = this._activatedRoute.snapshot.params['company'];
      this.handleChangeRoute(
        this._activatedRoute.snapshot.params['active'] + '/' + this.companyId
      );
    }

    this.isLoadingGet = true;
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.data = res;
      }
    });
    this.getAuthSetting();
    this.userGetVerifying();
  }
  
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getBankAccount() {
    this.isLoadingGetBankAccount = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.BankAccountGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetBankAccount = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.bankAccount = response.data;
            this._fileUploadService.fileUrlGeneratorPutBankCard(
              this.bankAccount,
              'avatarId'
            );
          },
          (error) => {}
        )
    );
  }
  getDataWallet() {
    this.isLoadingGetWallet = true;

    this.query = new BaseParams();
    this.query.pageSize = 100;
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, {
          transactionTypeList: '683,684,685,686',
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetWallet = false;
          })
        )
        .subscribe((res) => {
          if (res) {
            this.walletTransactions = cloneDeep(res.data);
            this.totalRecords = this.walletTransactions.length;
          }
        })
    );
  }

  userGetInfo() {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
          },
          (error) => {}
        )
    );
  }

  userGetDocument() {
    this.isLoadingGetDocument = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.DocumentGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetDocument = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.documents = response.data;
            if (this.documents != null) {
              for (let item of this.documents) {
                switch (item.documentType) {
                  case 136:
                    this.nationalCardId = item.fileId;

                    break;
                  case 139:
                    this.selfiImageId = item.fileId;

                    break;
                  default:
                    break;
                }
              }
            }
          },
          (error) => {}
        )
    );
  }

  handleChange(e) {
    e.originalEvent.target.scrollIntoView({
      behavior: 'smooth',
      block: 'center',
      inline: 'center',
    });
    switch (e.index) {
      case 0:
        this._router.navigateByUrl(
          '/dashboard/user/baseInformation' + '/' + this.companyId
        );
        break;
      case 1:
        this._router.navigateByUrl(
          '/dashboard/user/bankAccount' + '/' + this.companyId
        );

        break;

      case 2:
        this._router.navigateByUrl(
          '/dashboard/user/wallet' + '/' + this.companyId
        );

        break;
      case 6:
        this._router.navigateByUrl(
          '/dashboard/user/security' + '/' + this.companyId
        );
        break;
      case 3:
        this._router.navigateByUrl(
          '/dashboard/user/discounts' + '/' + this.companyId
        );
        break;
      case 4:
        this._router.navigateByUrl(
          '/dashboard/user/users' + '/' + this.companyId
        );
        break;
      case 5:
        this._router.navigateByUrl(
          '/dashboard/user/company' + '/' + this.companyId
        );

        break;

      // case 7:
      //   this._router.navigateByUrl(
      //     '/dashboard/user/accept-cash-exchange-wallet' + '/' + this.companyId
      //   );

      //   break;

      // case 8:
      //   this._router.navigateByUrl(
      //     '/dashboard/user/user-requests' + '/' + this.companyId
      //   );

      //   break;
    }
  }
  companyInfsoGet() {
    this.isLoadingGetCompany = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.CompanyGet, { companyId: this.companyId }, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            this.companyInfo = response.data;
            this.isLoadingGetCompany = false;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }
  handleChangeRoute(e: string) {
    switch (e) {
      case 'baseInformation' + '/' + this.companyId:
        this.indexTab = 0;
        break;
      case 'bankAccount' + '/' + this.companyId:
        this.indexTab = 1;
        if (!this.bankAccount || this.bankAccount.length == 0)
          this.getBankAccount();
        break;

      case 'wallet' + '/' + this.companyId:
        this.indexTab = 2;
        if (
          this.walletTransactions.length == 0 ||
          this.walletTransactions === null
        )
          this.getDataWallet();

        break;
      case 'security' + '/' + this.companyId:
        this.indexTab = 6;
        break;

      case 'discounts' + '/' + this.companyId:
        this.indexTab = 3;
        break;

      case 'users' + '/' + this.companyId:
        this.indexTab = 4;
        break;
      case 'company' + '/' + this.companyId:
        this.indexTab = 5;

        break;
    }
  }

  userGetVerifying() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;
            for (let item of this.dataVerifying) {
              switch (item.typeVerifying) {
                case 118:
                  if (item.isAccept == true)
                    this.isCompeleteBaseInformation = true;
                  break;
                case 111:
                  if (item.isAccept == true) this.isCompleteMobile = true;
                  break;
                case 112:
                  if (item.isAccept == true) this.isCompeleteEmail = true;
                  break;
                case 113:
                  if (item.isAccept == true) this.isCompeleteTel = true;
                  break;
                case 114:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentNationalCard = true;
                  this.nationalCardId = item.imageId;

                  break;
                case 116:
                  if (item.isAccept == true)
                    this.isCompeleteDocumentSelfi = true;
                  this.selfiImageId = item.imageId;

                  break;
                case 115:
                  if (item.isAccept == true) this.isCompeleteBanking = true;
                  break;
              }
            }
          },
          (error) => {}
        )
    );
  }
  getInfoActionUser(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBaseInformation = true;
    }
  }
  getInfoActionBank(e) {
    if (e != undefined && e == true) {
      this.isCompeleteBanking = true;
    }
  }
  getInfoActionTel(e) {
    if (e != undefined && e == true) {
      this.isCompeleteTel = true;
    }
  }
  getInfoActionEmail(e) {
    if (e != undefined && e == true) {
      this.isCompeleteEmail = true;
    }
  }

  getInfoActionMobile(e) {
    if (e != undefined && e == true) {
      this.isCompleteMobile = true;
    }
  }
}
