import configuration from '@config/config.json';
import {
  CUSTOM_ELEMENTS_SCHEMA,
  LOCALE_ID,
  NO_ERRORS_SCHEMA,
  NgModule,
} from '@angular/core';
import { CommonModule } from '@angular/common';
import { UserRoutingModule } from './user-routing.module';
import { UserComponent } from './user.component';
import { SharedModule } from '@shared/SharedModule';
import { ChangePasswordComponent } from './change-password/change-password.component';
import { TwoStepVerificationComponent } from './twoStepVerification/twoStepVerification.component';
import { CountdownModule } from 'ngx-countdown';
import { UserLevelComponent } from './user-level/userLevel.component';
import { WalletComponent } from './wallet/wallet.component';
import { WalletRechargeComponent } from './wallet/wallet-rechage/wallet-recharge.component';
import { CashExchangeWalletComponent } from './wallet/cash-exchange/cashExchange.component';
import { UserApplicationsComponent } from './user-applications/userApplications.component';
import { ModalChangePasswordComponent } from './change-password/changePasswordModal/changePasswordModal.component';
import { CaptchaModule } from '@components/captcha/captcha.component';
import { AddUserModalComponent } from './add-user/addUserModal/addUserModal.component';
import { AddUserComponent } from './add-user/addUser.component';
import { NgOtpInputModule } from 'ng-otp-input';
import { PersianCalenderModule } from '@components/persianCalender/persianCalender.Module';
import {
  RECAPTCHA_LOADER_OPTIONS,
  RECAPTCHA_SETTINGS,
  RecaptchaFormsModule,
  RecaptchaModule,
  RecaptchaSettings,
} from 'ng-recaptcha';

@NgModule({
  declarations: [
    ChangePasswordComponent,
    TwoStepVerificationComponent,
    UserComponent,
    UserLevelComponent,
    WalletComponent,
    WalletRechargeComponent,
    CashExchangeWalletComponent,
    UserApplicationsComponent,
    ModalChangePasswordComponent,
    AddUserModalComponent,
    AddUserComponent,
  ],
  imports: [
    CommonModule,
    UserRoutingModule,
    SharedModule,
    PersianCalenderModule,
    CountdownModule,
    CaptchaModule,
    NgOtpInputModule,
    RecaptchaModule,
    RecaptchaFormsModule,
  ],
  providers: [
    {
      provide: RECAPTCHA_SETTINGS,
      useValue: {
        siteKey: configuration.recaptchaSiteKey,
      } as RecaptchaSettings,
    },
    {
      provide: RECAPTCHA_LOADER_OPTIONS,
      useFactory: (locale: string) => ({
        onBeforeLoad(url) {
          url.searchParams.set('hl', locale);

          return { url };
        },
      }),
      deps: [LOCALE_ID],
    },
  ],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  exports: [SharedModule],
})
export class UserModule {}
