import { ChangeDetectionStrategy, Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CompanyInfoStore } from '@stores/companyInfo.store';

import { Subscription } from 'rxjs';

@Component({
  selector: 'accept-cash-exchange-wallet',
  templateUrl: 'accept.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AcceptCashExchangeWalletComponent implements OnInit {
  companyInfo = new CompanyInfoGet();
  constructor(
    public _activatedroute: ActivatedRoute,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
  }
  subscriptions = new Subscription();

  ngOnInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  navigateWalletPage() {
    window.location.href =
      '/dashboard/user-requests/' + this.companyInfo.companyId;
  }
}
