import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { response } from '@interfaces/response';
import { CompanyInfoGet } from '@models/user/companyInfoModel';
import { CommonService } from '@services/common.service';
import { CompanyInfoStore } from '@stores/companyInfo.store';
import { UserStore } from '@stores/user.store';

import { Subscription, finalize } from 'rxjs';

@Component({
  selector: 'cash-exchange-wallet',
  templateUrl: 'cashExchange.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CashExchangeWalletComponent implements OnInit {
  isLoading: boolean;
  walletAmount: any
  isValue: boolean;
  exchangePrice: number = 100000;
  companyInfo = new CompanyInfoGet();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _userStore: UserStore,
    private _alert: AlertHelper,
    public _activatedroute: ActivatedRoute,
    private _companyInfoStore: CompanyInfoStore
  ) {
    this._companyInfoStore.getCompany().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });
    this._companyInfoStore.getCompanyBehavior().subscribe((res) => {
      if (res != null) {
        this.companyInfo = res;
      }
    });

    this._userStore.getUser().subscribe((res) => {
      if (res && res.walletId) {

        this.walletAmount = Number(res.amountWallet);
      }
      this.cdr.detectChanges();
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res && res.walletId) {

        this.walletAmount = Number(res.amountWallet);
      }
      this.cdr.detectChanges();
    });
  }

  subscriptions = new Subscription();

  ngOnInit() { }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  valueController(event: any) {
    if (
      !this.exchangePrice ||
      this.exchangePrice === null ||
      this.exchangePrice == 0 ||
      this.exchangePrice < 1000
    ) {
      this.isValue = false;
    } else {
      this.isValue = true;
    }
  }
  navigateAcceptPage() {
    if (this.walletAmount < this.exchangePrice) {
      this._alert.warning('مقدار درخواستی از موجودی کیف پول بیشتر میباشد.')
    } else {

      this.isLoading = true;
      this.cdr.detectChanges();
      this.subscriptions.add(
        this._commonService
          .post(
            Address.cashApplicationSave,
            {
              price: this.exchangePrice,
            },
            false
          )
          .pipe(
            finalize(() => {
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (response: response) => {
              if (response) {
                window.location.href =
                  '/dashboard/accept-cash-exchange-wallet/' +
                  this.companyInfo.companyId;
              }
            },
            (error) => {
              this.isLoading = false;
              this.cdr.detectChanges();
            }
          )
      );
    }

  }
}
