import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';

import { Address } from '@enums/address.enum';

import { MessageStatic } from '@enums/messageStatic.enum';

import { CommonService } from '@services/common.service';
import { Location } from '@angular/common';
import { cloneDeep } from 'lodash-es';
import { Message } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { Subscription, finalize } from 'rxjs';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';

import { fadeAnimation } from 'src/app/core/animations/animations';
import { WalletRechargeComponent } from './wallet-rechage/wallet-recharge.component';
import { WalletModelGet } from '@models/user/WalletModelGet';
import { TableLazyLoadEvent } from 'primeng/table';
import { PagingHelper } from '@helpers/paging.helper';
import { CashExchangeWalletComponent } from './cash-exchange/cashExchange.component';
import { UserProfile } from '@interfaces/user/userProfile';
import { UserStore } from '@stores/user.store';
import { response } from '@interfaces/response';
import { AlertHelper } from '@helpers/alert.helper';
import { ColumnKey } from '@enums/columnKey.enum';

@Component({
  selector: 'wallet',
  templateUrl: './wallet.component.html',
  styleUrls: ['./wallet.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class WalletComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public dialogService: DialogService,
    private _router: Router,
    public _activatedroute: ActivatedRoute,
    public _pagingHelper: PagingHelper,
    public location: Location,
    private _userStore: UserStore,
    private _messageService: AlertHelper
  ) {}

  subscriptions = new Subscription();
  messages: Message[] = [];
  filter: any = {};
  @Input() walletTransactions: WalletModelGet[] = [];
  @Input() totalRecords: number = 0;
  isLoading: boolean = false;
  query: BaseParams;
  overlayPanel: boolean;
  search: OrderSearchModel = new OrderSearchModel();
  dataUser: UserProfile = new UserProfile();
  walletId: string;
  walletAmount;
  message: string = MessageStatic.NotFound;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  isLoadingActivate: boolean;
  loadingGetInfo: boolean;
  first: number = 0;
  last: number = 0;
  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }

  ngOnInit(): void {
    this.query = new BaseParams();
    this._userStore.getUser().subscribe((res) => {
      if (res && res.walletId) {
        this.walletId = res.walletId;
        this.walletAmount = res.amountWallet;
      }

      this.cdr.detectChanges();
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res && res.walletId) {
        this.walletId = res.walletId;
        this.walletAmount = res.amountWallet;
      }

      this.cdr.detectChanges();
    });

    this.getUserStore();
    this.cdr.detectChanges();
  }

  getUserStore() {
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.walletId = res.walletId;
        this.cdr.detectChanges();
      }
    });
  }

  userGetInfo() {
    this.loadingGetInfo = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.loadingGetInfo = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataUser = response.data;

            this._userStore.user.next(this.dataUser);
            this._userStore.userBehavior.next(this.dataUser);
            this.walletId = this.dataUser.walletId;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  goBackToPrevPage() {
    this.location.back();
  }
  activateWallet() {
    this.isLoadingActivate = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.WalletCreateByCustomer, {})
        .pipe(
          finalize(() => {
            this.isLoadingActivate = false;
          })
        )
        .subscribe((res) => {
          this.userGetInfo();
          this.cdr.detectChanges();
          this._messageService.success('کیف پول شما با موفقیت فعال شد.');
        })
    );
  }
  getData(event: TableLazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();

    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.query.companyId = this._activatedroute.snapshot.params['company'];
    this.query.transactionTypeList = '683,684,685,686';
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.walletTransactions = cloneDeep(res.data);
            this.totalRecords = res[ColumnKey.TotalRecordKey]
              ? res[ColumnKey.TotalRecordKey]
              : 0;
            this.first = this._pagingHelper.firstRecord(this.query);
            this.last = this._pagingHelper.lastRecord(
              this.query,
              this.totalRecords
            );

            this.cdr.detectChanges();
          }
        })
    );
  }
  toggle() {
    this.overlayPanel = !this.overlayPanel;
  }
  navigateToCashExchange() {
    this._router.navigateByUrl(
      '/dashboard/user-requests/' +
        this._activatedroute.snapshot.params['company']
    );

    // window.location.href =
    //   '/dashboard/user-requests/' +
    //   this._activatedroute.snapshot.params['company'];
  }
  walletRecharge(item: any = null) {
    const ref = this.dialogService.open(WalletRechargeComponent, {
      header: 'شارژ کیف پول',
      height: '85%',
      width: '40%',
      styleClass: 'wallet-modal',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  cashExchangeWallet() {
    const ref = this.dialogService.open(CashExchangeWalletComponent, {
      header: 'نقد کردن کیف پول',
      height: '70%',
      width: '40%',
      styleClass: 'wallet-modal',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }
}
