import {
  Component,
  OnInit,
  ViewEncapsulation,
  OnDestroy,
  AfterViewInit,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { CommonService } from '@services/common.service';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
@Component({
  selector: 'payment',
  templateUrl: 'payment.component.html',
  styleUrls: ['payment.component.scss'],
  encapsulation: ViewEncapsulation.None,
})
export class PaymentComponent implements OnInit, OnDestroy {
  isLoading: boolean = true;

  constructor(
    private _commonService: CommonService,
    private _router: Router,
    private _activatedRoute: ActivatedRoute
  ) {}

  orderNumber: any;
  subscriptions = new Subscription();
  ngOnInit() {
    this._activatedRoute.queryParamMap.subscribe((params) => {
      if (params.get('order')) {
        this.orderNumber = params.get('order');
        this.getPaymentLink();
      }
    });
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getPaymentLink() {
    this.subscriptions.add(
      this._commonService
        .post(Address.PaymentLink, { orderNumber: this.orderNumber })
        .pipe(
          finalize(() => {
            this.isLoading = false;
          })
        )
        .subscribe(
          (response: response) => {
            window.location.href = response.data.redirectUrl;
          },
          (error) => {}
        )
    );
  }

  goToHome() {
    this._router.navigateByUrl('/dashboard/home');
  }
}
