import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { cloneDeep } from 'lodash-es';
import { finalize } from 'rxjs/operators';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { SwiftTransferGetModel } from '@models/orders/SwiftTransferGetModel';
import { Subscription } from 'rxjs';
import { ApplicationFeeGetModel } from '@models/orders/ApplicationFeeGetModel';
import { PerfectMoneyBuyingGetModel } from '@models/orders/perfectMoneyBuyingGetModel';

import { SendRemittanceToIranGetModel } from '@models/orders/SendRemittanceToIranGetModel';
import { WiseAccountChargeGetModel } from '@models/orders/WiseAccountChargeGetModel';
import { PaymentInternationalSitesGetModel } from '@models/orders/PaymentInternationalSitesGetModel';
import { PayeerAccountRechargeGetModel } from '@models/orders/PayeerAccountRechargeGetModel';
import { ActivatedRoute, Params } from '@angular/router';
import { VoucherPerfectMoneyGetModel } from '@models/orders/VoucherPerfectMoneyGetModel';
import { SellingPerfectMoneyGetModel } from '@models/orders/sellingPerfectMoneyGetModel';
import { UserProfile } from '@interfaces/user/userProfile';
import { UserStore } from '@stores/user.store';
import { VirtualServersGetModel } from '@models/orders/VirtualServersGetModel';
import { RenewalVirtualServersGetModel } from '@models/orders/RenewalVirtualServersGetModel';
import { BuyTradeServersGetModel } from '@models/orders/BuyTradeServersGetModel';
import { RenewalTradeServersGetModel } from '@models/orders/RenewalTradeServersGetModel';
import { VoucherPerfectMoneySellGetModel } from '@models/orders/VoucherPerfectMoneySellGetModel';
import { GiftCardGetModel } from '@models/orders/GiftCardGetModel';
import { ApplicationFeeDetailSave } from '../core/params/order/ApplicationFeeDetailSaveModel';
import { ApplicationFeeDetailByIdModel } from '../core/params/order/AppliationFeeDetailById';
import { response } from '@interfaces/response';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { AdditionalFieldsSaveModel } from '../core/params/order/AdditionalFieldsSaveModel';
import { SellingWiseGetModel } from '@models/orders/sellingWiseGetModel';
import { FreeOrderGetModel } from '@models/orders/freeOrderGetModel';
import { IncomeCashGetModel } from '@models/orders/incomeCashGetModel';
@Component({
  selector: 'print',
  templateUrl: 'print.component.html',
  styleUrls: ['./print.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PrintComponent implements OnInit, OnDestroy {
  isLoading: boolean = true;
  currentDate: any;
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private activatedRoute: ActivatedRoute,
    private _userStore: UserStore
  ) {}

  subscriptions = new Subscription();
  dataSwift: SwiftTransferGetModel;
  dataPerfectMoneyCharge: PerfectMoneyBuyingGetModel;
  dataPerfectMoneyVoucher: VoucherPerfectMoneyGetModel;
  dataSendRemittanceToIran: SendRemittanceToIranGetModel;
  dataFee: ApplicationFeeGetModel;
  dataFreeOrder: FreeOrderGetModel;
  dataWiseAccountCharge: WiseAccountChargeGetModel;
  dataWiseSell: SellingWiseGetModel;
  dataGiftCard: GiftCardGetModel;
  dataPaymentInternationalSites: PaymentInternationalSitesGetModel;
  dataIncomeCash: IncomeCashGetModel;
  dataPayeerAccountRecharge: PayeerAccountRechargeGetModel;
  dataSellingPerfectMoney: SellingPerfectMoneyGetModel;
  buyVirtualServers: VirtualServersGetModel;
  renewalVirtualServers: RenewalVirtualServersGetModel;
  buyTradeServersGetModel: BuyTradeServersGetModel;
  sellVoucherPerfectMoneyModel: VoucherPerfectMoneySellGetModel;
  renewalTradeServersGetModel: RenewalTradeServersGetModel;
  timeout = null;
  isLoadingGet: boolean = false;
  isLoadingGetStatic: boolean;
  message: string = MessageStatic.NotFound;
  orderType: any;
  orderId: any;
  item: any;
  staticData: any;
  user: UserProfile;
  valueType: string;
  nationalCode: string;
  email: string;
  additionalFields: AdditionalFieldsSaveModel[] = [];

  applicationFeeDetailsData: ApplicationFeeDetailSave[] = [];
  multipleFeeById: ApplicationFeeDetailByIdModel;

  ngOnInit() {
    this.getDate();
    this.userGetInfo();
    this.activatedRoute.params.subscribe((params: Params) => {
      this.orderId = params['id'];
      this.orderType = Number(params['type']);
      this.valueType = params['value'];
    });

    if (!stringIsEmptyOrNull(this.valueType)) {
      switch (this.valueType) {
        case 'IWP':
          this.getPaymentInternationalSitesById();
          break;
        case 'PRM':
          this.getPermiumAccountById();
          break;
        case 'GFC':
          this.getGiftCardById();
          break;
        case 'PAC':
          this.getPaypalRechargeById();
          break;
        case 'PAS':
          this.getPaypalSellById();
          break;
        case 'APG':
          this.getApplicationFeeMultipleById();
          break;
        case 'LTN':
        case 'PVS':
          this.sellVoucherPerfectMoney();
          break;
        case 'PMS':
          this.getSellPerfectMoneyInfoById();
          break;
        case 'PVC':
          this.getPerfectMoneyVoucherById();
          break;
        case 'PMC':
          this.getPerfectMoneyChargeById();
          break;
        case 'WIC':
          this.getWiseAccountChargeById();
          break;
        case 'WIS':
          this.getSellingWiseById();
          break;
        case 'PYC':
          this.getPayeerAccountRechargeById();
          break;
        case 'PYS':
          this.getPaypalSellById();
          break;
        case 'SWF':
          this.getSwiftTransferById();
          break;
        case 'TRI':
          this.getSendRemittanceToIranById();
          break;
        case 'ORD':
          this.getFreeOrderById();
          break;
        case 'ICE':
          this.getIncomeCashById();
          break;
      }
    } else {
      switch (this.orderType) {
        case 161:
          this.getSwiftTransferById();
          break;
        case 171:
          this.getPaypalSellById();
          break;
        case 910:
          this.getPaypalRechargeById();
          break;
        case 162:
          this.getApplicationFeeById();
          break;
        case 175:
          this.getApplicationFeeById();
          break;
        case 165:
          this.getSellPerfectMoneyInfoById();
          break;
        case 177:
          this.getApplicationFeeById();
          break;
        case 163:
          this.getPerfectMoneyChargeById();
          break;
        case 164:
          this.getPerfectMoneyVoucherById();
          break;
        case 166:
          this.sellVoucherPerfectMoney();
          break;
        case 167:
          this.getSendRemittanceToIranById();
          break;
        case 173:
          this.getWiseAccountChargeById();
          break;
        case 169:
          this.getPayeerAccountRechargeById();
          break;
        case 178:
          this.buyVirtualServersFunc();
          break;
        case 179:
          this.renewalVirtualServersFunc();
          break;
        case 900:
          this.buyTradeServersGetModelFunc();
          break;
        case 901:
          this.renewalTradeServersGetModelFunc();
          break;
        case 905:
          this.getApplicationFeeMultipleById();
          break;
        case 999:
          this.getFreeOrderById();
          break;
        case 959:
          this.getIncomeCashById();
          break;
        case 960:
          this.getIncomeCashById();
          break;
        default:
          break;
      }
    }
  }

  userGetInfo() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(finalize(() => {}))
        .subscribe(
          (res) => {
            this.user = res.data;

            this.nationalCode = this.user.nationalCode;
            this.email = this.user.email;
            this._userStore.user.next(this.user);
            this._userStore.userBehavior.next(this.user);
          },
          (error) => {}
        )
    );
  }
  getStaticById() {
    this.isLoadingGetStatic = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: this.orderType,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetStatic = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.staticData = response.data;

            this.valueType = response.data.valueType;

            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPermiumAccountById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderPermiumAcountGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.item = cloneDeep(res.data[0]);
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  getPaypalSellById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalSellGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
 
            this.item = cloneDeep(res.data[0]);
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  getPaypalRechargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalRechargeGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.item = cloneDeep(res.data[0]);
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSwiftTransferById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SwiftTransferGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSwift = cloneDeep(res.data[0]);
            this.item = this.dataSwift;
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSellPerfectMoneyInfoById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPerfectMoneyGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSellingPerfectMoney = cloneDeep(res.data[0]);
            this.item = this.dataSellingPerfectMoney;
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPerfectMoneyChargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PerfectMoneyBuyingGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPerfectMoneyCharge = cloneDeep(res.data[0]);
            this.item = this.dataPerfectMoneyCharge;
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPerfectMoneyVoucherById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VoucherPerfectMoneyGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPerfectMoneyVoucher = cloneDeep(res.data[0]);
            this.item = this.dataPerfectMoneyVoucher;
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSendRemittanceToIranById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SendRemittanceToIranGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSendRemittanceToIran = cloneDeep(res.data[0]);
            this.item = this.dataSendRemittanceToIran;
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSellingWiseById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderSellingWiseGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataWiseAccountCharge = cloneDeep(res.data[0]);
            this.item = this.dataWiseAccountCharge;
            this.cdr.detectChanges();
          }
        })
    );
  }
 
  public getWiseAccountChargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.WiseAccountChargeGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataWiseAccountCharge = cloneDeep(res.data[0]);
            this.item = this.dataWiseAccountCharge;
            this.cdr.detectChanges();
          }
        })
    );
  }

  getGiftCardById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GiftCardGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataGiftCard = cloneDeep(res.data[0]);

            this.item = this.dataGiftCard;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  getPaymentInternationalSitesById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          this.dataPaymentInternationalSites = cloneDeep(res.data[0]);
          this.item = this.dataPaymentInternationalSites;
          this.additionalFields = JSON.parse(res.data[0].additionalValues);

          this.cdr.detectChanges();
        })
    );
  }

  getIncomeCashById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.IncomeCashGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          this.dataIncomeCash = cloneDeep(res.data[0]);
          this.item = this.dataIncomeCash;
          this.additionalFields = JSON.parse(res.data[0].additionalValues);

          this.cdr.detectChanges();
        })
    );
  }

  getPayeerAccountRechargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PayeerAccountRechargeGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPayeerAccountRecharge = cloneDeep(res.data[0]);
            this.item = this.dataPayeerAccountRecharge;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getApplicationFeeById() {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataFee = cloneDeep(res.data[0]);
            this.item = this.dataFee;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getFreeOrderById() {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.FreeOrderGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataFreeOrder = cloneDeep(res.data[0]);
            this.item = this.dataFreeOrder;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  printPage() {
    window.print();
  }

  getDate() {
    this.isLoading = true;
    this.subscriptions.add(
      this._commonService
        .get(Address.DateTime)
        .pipe(
          finalize(() => {
            this.isLoading = false;
          })
        )
        .subscribe((response) => {
          this.currentDate = response;
          this.cdr.detectChanges();
        })
    );
  }

  buyVirtualServersFunc() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.buyVirtualServers = cloneDeep(res.data[0]);
            this.item = this.buyVirtualServers;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);

            this.cdr.detectChanges();
          }
        })
    );
  }

  renewalVirtualServersFunc() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.RenewalVirtualServerGetPrice, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.renewalVirtualServers = cloneDeep(res.data[0]);
            this.item = this.renewalVirtualServers;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);

            this.cdr.detectChanges();
          }
        })
    );
  }

  buyTradeServersGetModelFunc() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.buyTradeServersGetModel = cloneDeep(res.data[0]);
            this.item = this.buyTradeServersGetModel;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);

            this.cdr.detectChanges();
          }
        })
    );
  }

  renewalTradeServersGetModelFunc() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.RenewalVirtualServerGetPrice, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.renewalTradeServersGetModel = cloneDeep(res.data[0]);
            this.item = this.renewalTradeServersGetModel;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);

            this.cdr.detectChanges();
          }
        })
    );
  }

  sellVoucherPerfectMoney() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VoucherPerfectMoneySellGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.sellVoucherPerfectMoneyModel = cloneDeep(res.data[0]);
            this.item = this.sellVoucherPerfectMoneyModel;
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.cdr.detectChanges();
          }
        })
    );
  }

  getApplicationFeeMultipleDetails(applicationFeeMultipleId: string) {
    this.isLoadingGet = true;

    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGroupDetailsGet, {
          applicationFeeMultipleId: applicationFeeMultipleId,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.applicationFeeDetailsData = cloneDeep(res.data);
            this.multipleFeeById.multipleDetails =
              this.applicationFeeDetailsData;

            this.cdr.detectChanges();
          }
        })
    );
  }
  public getApplicationFeeMultipleById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGroupGet, { orderId: this.orderId })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.multipleFeeById = cloneDeep(res.data[0]);
            this.additionalFields = JSON.parse(res.data[0].additionalValues);
            this.getApplicationFeeMultipleDetails(
              this.multipleFeeById.applicationFeeMultipleId
            );
            this.cdr.detectChanges();
          }
        })
    );
  }
}
