import {
  CUSTOM_ELEMENTS_SCHEMA,
  NgModule,
  NO_ERRORS_SCHEMA,
} from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { PrimeModule } from './prime.module';
import { NgxMaskModule } from 'ngx-mask';
import { DragDropDirective } from '@directives/dragdrop.directive';
import { NgNumberDirective } from '@directives/ngNumber.directive';
import { JalaliDatePipe } from '@pipes/jalaliDate.pipe';
import { PriceTypePipe } from '@pipes/priceType.pipe';
import { StatusOrderComponent } from '@components/statusOrder/statusOrder.component';
import { CharacterTypeDirective } from '@directives/characterType.directive';
import { VerifyingComponent } from '../modules/components/verifying/verifying.component';
import { CarouselModule } from 'ngx-owl-carousel-o';
import { CopyTextDirective } from '@directives/copyText.directive';
import { StatusSupportComponent } from '@components/statusSupport/statusSupport.component';
import { ScrollAnchorDirective } from '@directives/scroll/scrollAnchor.directive';
import { ScrollManagerDirective } from '@directives/scroll/scrollManager.directive';
import { ScrollSectionDirective } from '@directives/scroll/scrollSection.directive';
import { TranslateModule } from '@ngx-translate/core';
import { ImageLoadingComponent } from '@components/imageLoading/imageLoading.component';
import { TrackByPropertyDirective } from '@directives/trackByProperty.directive';
import { PaymentMethodComponent } from '../modules/components/paymentMethod/paymentMethod.component';
import { PaymentGatewayComponent } from '../modules/components/paymentGateway/paymentGateway.component';
import { FactorItemsComponent } from '../modules/components/factorItems/factorItems.component';
import { CardNumberPipe } from '@pipes/cardNumber.pipe';
import { QuestionListComponent } from '../modules/components/questionList/questionList.component';
import { SharpSymbolPipe } from '@pipes/sharpSymbol.pipe';
import { PrintPageComponent } from '../modules/components/printPage/printPage.component';
import { AcceptRolesComponent } from '../modules/components/acceptRoles/acceptRoles.component';
import { InputSwitchModule } from 'primeng/inputswitch';
import { OrderTypePipe } from '@pipes/orderType.pipe';
import { StepWizardComponent } from '../modules/stepWizard/step-wizard-checkout/step-wizard-checkout.component';
import { AlarmForMaximumPriceComponent } from '../modules/components/alarmForMaximumPrice/alarmForMaximumPrice.component';
import { DiscountTypePipe } from '@pipes/discountType.pipe';
import { DiscountInputComponent } from '../modules/components/discount-input/discountInput.component';
import { FilterUSDPipe } from '@pipes/USD-sign-filter.pipe';
import { ModalContentAdvertismentComponent } from '../modules/components/advertismentModal/modalContent/modalContent.component';
import { AdvertismentModalComponent } from '../modules/components/advertismentModal/advertismentModal.component';
import { AcceptCashExchangeWalletComponent } from '../modules/user/wallet/cash-exchange/accept-cash-exchange/accept.component';
import { TutorialModalComponent } from '../modules/components/tutorialModal/tutorialModal.component';
import { ModalContentTutorialComponent } from '../modules/components/tutorialModal/modalContent/modalContent.component';
import { AlarmOrderComponent } from '../modules/components/alarmOrder/alarmOrder.component';
import { OrderGiftcardModalComponent } from '../modules/services/service-giftCards/giftCard/order/orderGiftCardModal/orderGiftCardModal.component';
import { LimitationsComponent } from '../modules/services/components/limitations/limitations.component';
import { CeilOfNumber } from '@pipes/ceilNumber.pipe';
import { CountdownOrderComponent } from '../modules/components/countdownOrder/countdownOrder.component';
import { CountdownModule } from 'ngx-countdown';

import { OrderImageIdComponent } from '../modules/components/orderImage/orderImage.component';
import { FloorOfNumber } from '@pipes/floorNumber.pipe';
import { ModalContentMobileComponent } from '../modules/components/modalContentMobile/modalContentMobile.component';
import { MobileVerificationComponent } from '../modules/user/mobile-verification/mobile-verification.component';
import { UpdateProfileComponent } from '../modules/user/update-profile/update-profile.component';
import { EmailVerificationComponent } from '../modules/user/email-verification/email-verification.component';
import { LandlineVerificationComponent } from '../modules/user/landline-verification/landline-verification.component';
import { BankAccountComponent } from '../modules/user/bank-account/bank-account.component';
import { UploaderNationalCardComponent } from '../modules/user/uploader-nationalCard/uploaderNationalCard.component';
import { UploaderSelfiImageComponent } from '../modules/user/uploader-selfiImage/uploaderSelfiImage.component';
import { AddBankAccountComponent } from '../modules/user/bank-account/add-bank-account/addBankAccount.component';
import { DatePickerSelectModule } from '@components/datePickerSelect/datePickerSelect.component';
import { SearchFilterPipe } from '@pipes/search.pipe';
import { OnlyNumberInputDirective } from '@directives/onlyNumberInput.directive';
import { DiscountsComponent } from '../modules/financial/discounts/discounts.component';
import { NewDiscountComponent } from '../modules/financial/discounts/newDiscount/newDiscount.component';
import { BlockAccessOrderComponent } from '../modules/components/blockAccessOrder/BlockAccessOrderComponent';
import { PersianCalenderModule } from '@components/persianCalender/persianCalender.Module';

import { OrderVerifyComponent } from '../modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { OrderDescriptionComponent } from '../modules/components/orderDescription/orderDescription.component';
import { CeilOrFloorOfNumber } from '@pipes/ceilOrFloor.pipe';
import { NotificationAfterSaveComponent } from '../modules/components/notificationAfterSave/notificationAfterSave.component';
import { NotificationBeforeSaveComponent } from '../modules/components/notificationBeforeSave/notificationBeforeSave.component';
import { CopyWalletDirective } from '@directives/copyWalletValue.directive';
import { TruncateDecimalPipe } from '@pipes/decimal.pipe';
import { FactorDetailsComponent } from '../modules/components/factorDetails/factorDetails.component';
import { SubmitCheckoutComponent } from '@components/submitCheckout/submitCheckout.component';

@NgModule({
  declarations: [
    DragDropDirective,
    CopyTextDirective,
    CopyWalletDirective,
    NgNumberDirective,
    CharacterTypeDirective,
    TrackByPropertyDirective,
    JalaliDatePipe,
    PriceTypePipe,
    SearchFilterPipe,
    CeilOrFloorOfNumber,
    OrderTypePipe,
    DiscountTypePipe,
    TruncateDecimalPipe,
    CeilOfNumber,
    FloorOfNumber,
    SharpSymbolPipe,
    CardNumberPipe,
    FilterUSDPipe,
    StatusOrderComponent,
    StatusSupportComponent,
    VerifyingComponent,
    AlarmOrderComponent,
    AlarmForMaximumPriceComponent,
    AcceptRolesComponent,
    ScrollAnchorDirective,
    ScrollManagerDirective,
    ScrollSectionDirective,
    DiscountInputComponent,
    ImageLoadingComponent,
    PaymentMethodComponent,
    PaymentGatewayComponent,
    FactorItemsComponent,
    FactorDetailsComponent,
    QuestionListComponent,
    PrintPageComponent,
    StepWizardComponent,
    NewDiscountComponent,
    DiscountsComponent,
    ModalContentMobileComponent,
    ModalContentAdvertismentComponent,
    AdvertismentModalComponent,
    TutorialModalComponent,
    AcceptCashExchangeWalletComponent,
    ModalContentTutorialComponent,
    OrderGiftcardModalComponent,
    LimitationsComponent,
    CountdownOrderComponent,
    BlockAccessOrderComponent,
    OrderImageIdComponent,
    MobileVerificationComponent,
    UpdateProfileComponent,
    EmailVerificationComponent,
    LandlineVerificationComponent,
    AddBankAccountComponent,
    BankAccountComponent,
    UploaderNationalCardComponent,
    UploaderSelfiImageComponent,
    OnlyNumberInputDirective,
    OrderDescriptionComponent,
    OrderVerifyComponent,
    NotificationAfterSaveComponent,
    NotificationBeforeSaveComponent,
    SubmitCheckoutComponent
  ],
  imports: [
    CommonModule,
    PrimeModule,
    NgxMaskModule.forRoot(),
    CarouselModule,
    TranslateModule,
    InputSwitchModule,
    CountdownModule,
    DatePickerSelectModule,
    PersianCalenderModule,
  ],
  exports: [
    FormsModule,
    PrimeModule,
    ReactiveFormsModule,
    CarouselModule,
    CommonModule,
    CeilOrFloorOfNumber,
    CharacterTypeDirective,
    TrackByPropertyDirective,
    NgxMaskModule,
    DragDropDirective,
    CopyTextDirective,
    CopyWalletDirective,
    NgNumberDirective,
    OnlyNumberInputDirective,
    ScrollAnchorDirective,
    ScrollManagerDirective,
    ScrollSectionDirective,
    JalaliDatePipe,
    CardNumberPipe,
    PriceTypePipe,
    SearchFilterPipe,
    CeilOfNumber,
    FloorOfNumber,
    DiscountTypePipe,
    TruncateDecimalPipe,
    SharpSymbolPipe,
    OrderTypePipe,
    FilterUSDPipe,
    StatusOrderComponent,
    StatusSupportComponent,
    VerifyingComponent,
    AlarmOrderComponent,
    AlarmForMaximumPriceComponent,
    AcceptRolesComponent,
    TranslateModule,
    ImageLoadingComponent,
    PaymentMethodComponent,
    PaymentGatewayComponent,
    FactorItemsComponent,
    FactorDetailsComponent,
    QuestionListComponent,
    PrintPageComponent,
    StepWizardComponent,
    DiscountInputComponent,
    NewDiscountComponent,
    DiscountsComponent,
    ModalContentMobileComponent,
    ModalContentAdvertismentComponent,
    AdvertismentModalComponent,
    TutorialModalComponent,
    AcceptCashExchangeWalletComponent,
    InputSwitchModule,
    ModalContentTutorialComponent,
    OrderGiftcardModalComponent,
    LimitationsComponent,
    CountdownOrderComponent,
    BlockAccessOrderComponent,
    OrderImageIdComponent,
    ModalContentMobileComponent,
    MobileVerificationComponent,
    UpdateProfileComponent,
    EmailVerificationComponent,
    LandlineVerificationComponent,
    AddBankAccountComponent,
    BankAccountComponent,
    UploaderNationalCardComponent,
    UploaderSelfiImageComponent,
    OrderDescriptionComponent,
    OrderVerifyComponent,
    NotificationAfterSaveComponent,
    NotificationBeforeSaveComponent,
    SubmitCheckoutComponent
  ],
  providers: [],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
})
export class SharedModule {}
