import { CUSTOM_ELEMENTS_SCHEMA, NgModule, NO_ERRORS_SCHEMA, isDevMode } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { AppComponent } from './app.component';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { CoreModule } from './core/core.module';
import { AppRoutingModule } from './app.routes';
import { SharedModule } from '@shared/SharedModule';
import { AppTranslateModule } from '@shared/app-translate.module';
import { CommonModule } from '@angular/common';
import { ServiceWorkerModule } from '@angular/service-worker';
import { GoogleTagManagerModule } from 'angular-google-tag-manager';
import configuration from '@config/config.json';
import { OnlineStatusModule } from 'ngx-online-status';
import { GoogleSigninButtonModule} from '@abacritt/angularx-social-login';
import { NetworkSpeedService } from '@services/networkspeed.service';

@NgModule({
  declarations: [
    AppComponent,
  ], 
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    CommonModule,
    CoreModule,
    SharedModule,
    AppRoutingModule,
    AppTranslateModule,
    OnlineStatusModule,
    GoogleSigninButtonModule,
    ServiceWorkerModule.register('ngsw-worker.js', {
     enabled: !isDevMode(),
      registrationStrategy: 'registerWhenStable:30000'
    }),
    GoogleTagManagerModule.forRoot({
      id: configuration.googleTagManagerId,
    })
  ],
  providers: [{ provide: 'googleTagManagerId', useValue: configuration.googleTagManagerId },
    NetworkSpeedService
  ],
  exports: [CoreModule],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  bootstrap: [AppComponent]
})
export class AppModule {
}
