import {
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewEncapsulation,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { GetSettingAuth } from '@models/auth/authSettingGetModel';
import { CommonService } from '@services/common.service';
import { AuthStore } from '@stores/AuthSetting.store';
import { TypeVerifyingStore } from '@stores/verifyingWithGoogle.store';
import {
  Subscription,
  distinctUntilChanged,
  filter,
  finalize,
  skip,
} from 'rxjs';
import { ConstantService } from './../core/services/constant.service';

@Component({
  selector: 'auth-root',
  templateUrl: './auth.component.html',
  styleUrls: ['./auth.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class AuthComponent implements OnInit, OnDestroy {
  isGoogleVerifying: boolean = false;
  subscriptions = new Subscription();
  isLoadingGetIp: boolean;
  isGetAuthSetting: boolean;
  isCloseAlarmer: boolean = false;
  settingAuth: GetSettingAuth = new GetSettingAuth();
  clientIp: { ip: any } = { ip: null };
  showLogo: boolean = false

  publicAlarm: string =
    'کاربر گرامی، ارسال پیامک ها با کمی تاخیر انجام میشود. لطفا تا حل مشکل صبوری بفرمایید.';
  constructor(
    private _isGoogleVerifying: TypeVerifyingStore,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _authSettingStore: AuthStore,
    private constantService: ConstantService
  ) {}
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

ngOnInit(): void {
  this.initComponent();
}

private async initComponent() {
  this.getAuthSetting();
  this.subscriptions.add(
    this.constantService.isForeign$
      .pipe(
        distinctUntilChanged(),
        skip(1),
        filter((val) => val !== null)
      )
      .subscribe((newIsForeign) => {
        if (newIsForeign === true) {
          this.getAuthSetting();
        }
      })
  );

  const locationStr = localStorage.getItem('user-location');
  if (locationStr) {
    const location = JSON.parse(locationStr);
    this.showLogo = location.countryCode == 'IR';
  }
}

  closeAlarmer() {
    this.isCloseAlarmer = true;
  }

  getAuthSetting() {
    this.isGetAuthSetting = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.AuthSettingGet)
        .pipe(
          finalize(() => {
            this.isGetAuthSetting = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.settingAuth = response.data;

            this._authSettingStore.isActiveCaptcha.next(
              this.settingAuth.isActiveCaptcha
            );
            this._authSettingStore.isActiveCaptchaBehavior.next(
              this.settingAuth.isActiveCaptcha
            );

            this._authSettingStore.isActiveOAuth.next(
              this.settingAuth.isActiveOAuth
            );
            this._authSettingStore.isActiveOAuthBehavior.next(
              this.settingAuth.isActiveOAuth
            );

            this._authSettingStore.isActiveWhatsapp.next(
              this.settingAuth.isActiveWhatsapp
            );
            this._authSettingStore.isActiveWhatsappBehavior.next(
              this.settingAuth.isActiveWhatsapp
            );

            this._authSettingStore.isActiveAuthenticationMobile.next(
              this.settingAuth.isActiveAuthenticationMobile
            );
            this._authSettingStore.isActiveAuthenticationMobileBehavior.next(
              this.settingAuth.isActiveAuthenticationMobile
            );

            this._authSettingStore.isActiveSms.next(
              this.settingAuth.isActiveSms
            );
            this._authSettingStore.isActiveSmsBehavior.next(
              this.settingAuth.isActiveSms
            );

            this._authSettingStore.isActiveAuthenticationEmail.next(
              this.settingAuth.isActiveAuthenticationEmail
            );
            this._authSettingStore.isActiveAuthenticationEmailBehavior.next(
              this.settingAuth.isActiveAuthenticationEmail
            );

            this._authSettingStore.isActiveEmail.next(
              this.settingAuth.isActiveEmail
            );
            this._authSettingStore.isActiveEmailBehavior.next(
              this.settingAuth.isActiveEmail
            );

            this._authSettingStore.isActiveTTS.next(
              this.settingAuth.isActiveTTS
            );
            this._authSettingStore.isActiveTTSBehavior.next(
              this.settingAuth.isActiveTTS
            );

            this._authSettingStore.showHelpLogin.next(
              this.settingAuth.showHelpLogin
            );
            this._authSettingStore.showHelpLoginBehavior.next(
              this.settingAuth.showHelpLogin
            );

            this._authSettingStore.parallelSendingWhatsappLogin.next(
              this.settingAuth.parallelSendingWhatsappLogin
            );
            this._authSettingStore.parallelSendingWhatsappLoginBehavior.next(
              this.settingAuth.parallelSendingWhatsappLogin
            );

            this._authSettingStore.isActiveRecaptcha.next(
              this.settingAuth.isActiveGoogleRecaptcha
            );
            this._authSettingStore.isActiveRecaptchahBehavior.next(
              this.settingAuth.isActiveGoogleRecaptcha
            );

            this._authSettingStore.isActiveBotTelegram.next(
              this.settingAuth.isActiveBotTelegram
            );
            this._authSettingStore.isActiveBotTelegramBehavior.next(
              this.settingAuth.isActiveBotTelegram
            );

            this._authSettingStore.parallelSendingTelegramLogin.next(
              this.settingAuth.parallelSendingTelegramLogin
            );
            this._authSettingStore.parallelSendingTelegramLoginBehavior.next(
              this.settingAuth.parallelSendingTelegramLogin
            );

            this._authSettingStore.userNameBotTelegram.next(
              this.settingAuth.userNameBotTelegram
            );
            this._authSettingStore.userNameBotTelegramBehavior.next(
              this.settingAuth.userNameBotTelegram
            );

            this._isGoogleVerifying.getTypeVerifying().subscribe((res) => {
              this.isGoogleVerifying = res;
            });
            this._isGoogleVerifying
              .getTypeVerifyingBehavior()
              .subscribe((res) => {
                this.isGoogleVerifying = res;
              });
          },
          (error) => {}
        )
    );
  }
}
