import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AuthComponent } from './auth.component';
import { VerifyComponent } from './verify/verify.component';
import { AccessChildGuard } from 'src/app/core/guards/access-child.guard';
import { LoginRegisterWizardComponent } from './loginRegisterWizard/loginRegisterWizard.component';
const routes: Routes = [
  {
    path: '',
    component: AuthComponent,
    
    children: [
      {
        path: '',
        component: LoginRegisterWizardComponent,
        data: { title: 'ورود' },
      },
      {
        path: 'login',
        component: LoginRegisterWizardComponent,
        data: { title: 'ورود با نام کاربری' },
      },
      {
        path: 'loginByUserName',
        component: LoginRegisterWizardComponent,
        data: { title: 'ورود با نام کاربری' },
      },
      {
        path: 'register',
        component: LoginRegisterWizardComponent,
        data: { title: 'ورود با نام کاربری' },
      },
    
      {
        path: 'verify',
        children:
        [
          {path:'',component:VerifyComponent}
        ],
        canActivateChild:[AccessChildGuard],
        data: { title: 'تایید کد یکبار مصرف' },
      }, 
      {
        path: 'verify/:language',
        children:
        [
          {path:'',component:VerifyComponent}
        ],
        canActivateChild:[AccessChildGuard],
        data: { title: 'تایید کد یکبار مصرف' },
      }, 
      

      
      { path: '', pathMatch: 'full', redirectTo: 'login' }
    ],
  },
 
];
@NgModule({
  imports: [[RouterModule.forChild(routes)]],
  exports: [RouterModule],
})
export class AuthRoutingModule {}
