import { Component, EventEmitter, OnDestroy, Output } from '@angular/core';
import { AuthStore } from '@stores/AuthSetting.store';
import { Subscription } from 'rxjs';

declare global {
  interface Window {
    google: any;
  }
}

@Component({
  selector: 'app-google-signin',
  templateUrl: './googleSignin.component.html',
  styleUrls: ['./googleSignin.component.scss'],
})
export class GoogleSigninComponent implements OnDestroy {
  subscriptions = new Subscription();
  isActiveOAuth: boolean;
  constructor(private _authSettingStore: AuthStore) {}
  ngOnInit(): void {
    this._authSettingStore.isActiveOAuth.subscribe((res) => {
      if (res != null) {
        this.isActiveOAuth = res;
      }
    });

    this._authSettingStore.isActiveOAuthBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveOAuth = res;
      }
    });
  }
  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }
  @Output() loginWithGoogle: EventEmitter<any> = new EventEmitter<any>();

  createFakeGoogleWrapper = () => {
    const googleLoginWrapper = document.createElement('div');
    googleLoginWrapper.style.display = 'none';
    googleLoginWrapper.classList.add('custom-google-button');
    document.body.appendChild(googleLoginWrapper);
    window.google.accounts.id.renderButton(googleLoginWrapper, {
      type: 'icon',
      width: '200',
    });
    const googleLoginWrapperButton = googleLoginWrapper.querySelector(
      'div[role=button]'
    ) as HTMLElement;

    return {
      click: () => {
        googleLoginWrapperButton?.click();
      },
    };
  };

  handleGoogleLogin() {
    if (this.isActiveOAuth) {
      this.loginWithGoogle.emit(this.createFakeGoogleWrapper());
    }
  }
}
