import {
  AfterViewInit,
  Component,
  Input,
  OnDestroy,
  OnInit,
  ViewChild,
} from '@angular/core';
import { CommonService } from '@services/common.service';
import { Subscription } from 'rxjs';
import { finalize, filter, pairwise, tap } from 'rxjs/operators';
import { response } from '@interfaces/response';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ActivatedRoute, Router, RoutesRecognized } from '@angular/router';
import { Address } from '@enums/address.enum';
import { CaptchaComponent } from '@components/captcha/captcha.component';
import { setSessionStorageItem } from '@helpers/sessionStorage.helper';
import { ColumnKey } from '@enums/columnKey.enum';
import { LoginModel } from 'src/app/core/params/auth/loginModel';
import { RedirectorHelper } from '@helpers/redirector.helper';
import { AuthStore } from '@stores/AuthSetting.store';
import { UsernameStore } from '@stores/loginUsenameStore.store';
import { toEnglishDigits } from '@helpers/convertToEnglishDigit.helper';
import { CountryModel } from '@models/orders/CountryModel';
import { TelegramSetting } from 'src/app/core/constants/telegramSettings.constant';

@Component({
  selector: 'form-login',
  templateUrl: './formLogin.component.html',
  styleUrls: ['./formLogin.component.scss'],
})
export class FormLoginComponent implements OnDestroy, AfterViewInit, OnInit {
  isLoading: boolean = false;
  subscriptions = new Subscription();
  isNumber: boolean = true;
  model: LoginModel = new LoginModel();
  prevUrl: string;
  currentUrl: string;
  @Input() isLoadingGetCountry: boolean = false;
  @Input() selectedCountry!: CountryModel;
  @Input() isLodingGetUrl: boolean = false;
  @Input() dataCountry: CountryModel[] = [];
  loginMethod: 'email' | 'mobile' = 'mobile';
  typeSendCodeToMobile: any = {
    label: 'پیامک',
    value: 'sms',
    icon: 'pi pi-envelope',
  };
  isActiveCaptcha: boolean;
  isActiveWhatsapp: boolean;
  isActiveAuthenticationEmail: boolean;
  isActiveEmail: boolean;
  isActiveAuthenticationMobile: boolean;
  isActiveSms: boolean;
  parallelSendingWhatsappLogin: boolean;
  parallelSendingTelegramLogin: boolean;
  isActiveBotTelegram: boolean;
  userNameBotTelegram: string;
  @ViewChild('captcha') captcha: CaptchaComponent;
  @ViewChild('loginForm') loginForm: any;
  isLoadingConnect: boolean = false;
  isLoadingDisconnect: boolean = false;
  showTelegramAlarm: boolean = false;
  optionsTypeSendCodeToMobile = [
    { label: 'پیامک', value: 'sms', icon: 'pi pi-envelope' },
  ];
  constructor(
    private _commonService: CommonService,
    private _router: Router,
    public _redirectorHelper: RedirectorHelper,
    private _authSettingStore: AuthStore,
    private _usernameStore: UsernameStore,
    private _route: ActivatedRoute
  ) {
    this.subscriptions = this._router.events
      .pipe(
        filter((evt: any) => evt instanceof RoutesRecognized),
        tap((event) => {}),
        pairwise()
      )
      .subscribe((events: RoutesRecognized[]) => {});

    this._authSettingStore.isActiveWhatsapp.subscribe((res) => {
      if (res != null) {
        this.isActiveWhatsapp = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.isActiveWhatsappBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveWhatsapp = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.isActiveAuthenticationMobileBehavior.subscribe(
      (res) => {
        if (res != null) {
          this.isActiveAuthenticationMobile = res;
          this.updateSendOptions();
        }
      }
    );

    this._authSettingStore.isActiveSmsBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveSms = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.parallelSendingWhatsappLogin.subscribe((res) => {
      if (res != null) {
        this.parallelSendingWhatsappLogin = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.parallelSendingWhatsappLoginBehavior.subscribe(
      (res) => {
        if (res != null) {
          this.parallelSendingWhatsappLogin = res;
          this.updateSendOptions();
        }
      }
    );

    this._authSettingStore.parallelSendingTelegramLogin.subscribe(
      (res) => {
        if (res != null) {
          this.parallelSendingTelegramLogin = res;
          this.updateSendOptions();
        }
      }
    );

    this._authSettingStore.parallelSendingTelegramLoginBehavior.subscribe(
      (res) => {
        if (res != null) {
          this.parallelSendingTelegramLogin = res;
          this.updateSendOptions();
        }
      }
    );

    this._authSettingStore.isActiveBotTelegram.subscribe((res) => {
      if (res != null) {
        this.isActiveBotTelegram = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.isActiveBotTelegramBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveBotTelegram = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.userNameBotTelegram.subscribe((res) => {
      if (res != null) {
        this.userNameBotTelegram = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.userNameBotTelegramBehavior.subscribe((res) => {
      if (res != null) {
        this.userNameBotTelegram = res;
        this.updateSendOptions();
      }
    });

    this._authSettingStore.isActiveAuthenticationEmailBehavior.subscribe(
      (res) => {
        if (res != null) {
          this.isActiveAuthenticationEmail = res;
        }
      }
    );

    this._authSettingStore.isActiveEmailBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveEmail = res;
      }
    });

    this._authSettingStore.isActiveCaptcha.subscribe((res) => {
      if (res != null) {
        this.isActiveCaptcha = res;
      }
    });

    this._authSettingStore.isActiveCaptchaBehavior.subscribe((res) => {
      if (res != null) {
        this.isActiveCaptcha = res;
      }
    });

    this._usernameStore.username.subscribe((res) => {
      if (res != null) {
        this.model.address = res;
      }
    });

    this._usernameStore.usernameBehavior.subscribe((res) => {
      if (res != null) {
        this.model.address = res;
      }
    });
  }

  ngOnInit(): void {
    this._route.queryParams.subscribe((params) => {
      if (params['method']) {
        this.loginMethod = params['method'];
      }
    });
    const nav = history.state;
    if (nav.method) {
      this.loginMethod = nav.method;
    }
    if (nav.address) {
      this.model.address = nav.address;
    }
    if (nav.typeVerify) {
      this.model.typeVerify = nav.typeVerify;
    }
    const locationStr = localStorage.getItem('user-location');
    if (locationStr) {
      const location = JSON.parse(locationStr);
      if (location.countryCode == 'IR') {
        this.showTelegramAlarm = false;
      } else {
        this.showTelegramAlarm = true;
      }
    }
  }

  ngAfterViewInit(): void {}

  updateSendOptions() {
    this.optionsTypeSendCodeToMobile = [];

    if (this.isActiveBotTelegram) {
      this.optionsTypeSendCodeToMobile.push({
        label: 'تلگرام',
        value: 'telegram',
        icon: 'pi pi-telegram',
      });
    }

    if (
      this.isActiveWhatsapp &&
      !this.parallelSendingWhatsappLogin &&
      this.isActiveAuthenticationMobile &&
      this.isActiveSms
    ) {
      this.optionsTypeSendCodeToMobile.push({
        label: 'واتساپ',
        value: 'whatsapp',
        icon: 'pi pi-whatsapp',
      });
    }

    if (this.isActiveAuthenticationMobile && this.isActiveSms) {
      this.optionsTypeSendCodeToMobile.push({
        label: 'پیامک',
        value: 'sms',
        icon: 'pi pi-envelope',
      });
    }
  }

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
    this.loginForm.resetForm();
  }

  getSubmitMethod(): any {
    return {
      callSubmitMethod: () => {
        if (
          this.captcha.CaptchaCode &&
          !stringIsEmptyOrNull(this.captcha.CaptchaCode.value)
        ) {
          this.submit();
        }
      },
    };
  }

  private normalizeSendFlags() {
  if (this.typeSendCodeToMobile) {
    const val = this.typeSendCodeToMobile.value;
    this.model.sendCodeToWhatsApp = val === 'whatsapp';
    this.model.sendCodeToTelegram = val === 'telegram';
  } else {
    this.model.sendCodeToWhatsApp = false;
    this.model.sendCodeToTelegram = false;
  }
  this._authSettingStore.sendCodeToWhatsappBehavior.next(!!this.model.sendCodeToWhatsApp);
  this._authSettingStore.sendCodeToTelegramBehavior.next(!!this.model.sendCodeToTelegram);
}

  submit() {
    this.normalizeSendFlags();
    if (this.selectedCountry) {
      this.model.prefixPhone = this.selectedCountry.prefixPhone;
      this.model.countryId = this.selectedCountry.countryId;
    }
    if (this.typeSendCodeToMobile) {
      if (this.typeSendCodeToMobile.value == 'whatsapp') {
        this.model.sendCodeToWhatsApp = true;
        this.model.sendCodeToTelegram = false;
        this._authSettingStore.sendCodeToWhatsappBehavior.next(
          this.model.sendCodeToWhatsApp
        );
      } else if (this.typeSendCodeToMobile.value == 'telegram') {
        this.model.sendCodeToTelegram = true;
        this.model.sendCodeToWhatsApp = false;
        this._authSettingStore.sendCodeToTelegramBehavior.next(
          this.model.sendCodeToTelegram
        );
      } else {
        this.model.sendCodeToTelegram = false;
        this.model.sendCodeToWhatsApp = false;
      }
    }

    this.model.address = toEnglishDigits(this.model.address);

    if (
      (this.captcha &&
        this.captcha.captchaInfo &&
        this.captcha.captchaInfo.captchaId &&
        this.captcha.captchaInfo.captchaCode) ||
      !this.isActiveCaptcha
    ) {
      if (this.isActiveCaptcha) {
        const { captchaCode, captchaId } = this.captcha.captchaInfo;

        this.model.captchaCode = captchaCode;
        this.model.captchaCode = toEnglishDigits(this.model.captchaCode);
        this.model.captchaId = captchaId;
      } else {
        this.model.captchaCode = null;
        this.model.captchaId = null;
      }
      this.isLoading = true;

      this.subscriptions.add(
        this._commonService
          .post(Address.Send, this.model, false)
          .pipe(
            finalize(() => {
              this.isLoading = false;
              setSessionStorageItem(
                ColumnKey.countryId,
                this.model.countryId
              );
              this.captcha.handleRefreshCaptcha();
            })
          )
          .subscribe(
            (response: response) => {
              setSessionStorageItem(ColumnKey.Address, response.data.address);
              setSessionStorageItem(ColumnKey.TokenVerify, response.data.token);
              setSessionStorageItem(
                ColumnKey.PrefixPhone,
                response.data.prefixPhone
              );
              setSessionStorageItem(
                ColumnKey.TypeVerify,
                response.data.typeVerify
              );
              this._redirectorHelper.routerHandlerAuth('verify');
            },
            (error) => {}
          )
      );
    }
  }

  conneectToTelegram() {
    this.isLoadingConnect = true;
    const fullTelegramUrl =
      TelegramSetting.telegramBaseUrl + this.userNameBotTelegram;
    window.open(fullTelegramUrl, '_blank');
    this.isLoadingConnect = false;
  }
}
