import { Component, OnDestroy, ViewChild } from '@angular/core';
import { Subscription } from 'rxjs';
import { CaptchaComponent } from '@components/captcha/captcha.component';
import { RedirectorHelper } from '@helpers/redirector.helper';

@Component({
  selector: 'login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss'],
})
export class LoginComponent implements OnDestroy {
  subscriptions = new Subscription();

  @ViewChild('captcha') captcha: CaptchaComponent;
  @ViewChild('loginForm') loginForm: any;
  constructor(
    public _redirectorHelper: RedirectorHelper
  ) {
  
  }

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
    this.loginForm.resetForm();
  }


}
