import { Component, ViewEncapsulation, OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs';
import { MenuItem } from 'primeng/api/public_api';
import { UserProfile } from '@interfaces/user/userProfile';
import { Router } from '@angular/router';
import { BaseParams } from 'src/app/core/params/user/baseParams';

@Component({
    selector: 'callback-online-payment',
    templateUrl: 'callback-online-payment.component.html',
    encapsulation: ViewEncapsulation.None,
})
export class CallBackOnlinePaymentComponent implements OnDestroy {
    constructor(
        private _router: Router,
    ) { }
    query: BaseParams = new BaseParams();
    subscriptions = new Subscription();
    menuItems: MenuItem[];
    showSide = false;
    data: UserProfile;

    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }


    hide() {
        this.showSide = false;
    }
    goToHome() {
        this._router.navigateByUrl('/dashboard/home');
    }

}
