import { Component, ViewEncapsulation, OnDestroy } from '@angular/core';
import {Subscription } from 'rxjs';
import { MenuItem } from 'primeng/api/public_api';
import { UserProfile } from '@interfaces/user/userProfile';
import { Router } from '@angular/router';
import { BaseParams } from '../core/params/user/baseParams';

@Component({
    selector: 'callback',
    templateUrl: 'callback.component.html',
    encapsulation: ViewEncapsulation.None,
})
export class CallBackComponent implements OnDestroy {
    constructor(
        private _router: Router,
    ) { }
    query: BaseParams = new BaseParams();
    subscriptions = new Subscription();
    menuItems: MenuItem[];
    showSide = false;
    data: UserProfile;
 
    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }


    hide() {
        this.showSide = false;
    }
    goToHome() {
        this._router.navigateByUrl('/dashboard/home');
    }

}
