import { Component, EventEmitter, Input, Output } from '@angular/core';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { TranslateService } from '@ngx-translate/core';
import { UserStore } from '@stores/user.store';
import { ConfirmationService } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { AutoUnsubscribe } from 'src/app/core/decorators/AutoUnSubscribe';
import { WalletRechargeComponent } from 'src/app/modules/user/wallet/wallet-rechage/wallet-recharge.component';

@AutoUnsubscribe({ arrayName: 'subscriptions' })
@Component({
  selector: 'submitCheckout',
  templateUrl: './submitCheckout.component.html',
})
export class SubmitCheckoutComponent {
  @Input() checkedRole: boolean;
  @Input() dataCheckout: any;
  @Input() isExpired: boolean;
  @Input() isLoading: boolean;
  @Input() bankPort: any;
  @Input() payType: any;
  @Input() orderType: any;
  @Input() checkBankAccount: any;
  @Input() isDisabledWallet;
  @Input() bankId;
  @Input() isApplicationFee: boolean = false;
  @Output('updateStatusDocument') updateStatusDocument: EventEmitter<any> =
    new EventEmitter();
  @Output('updateStatusSmartPayment')
  updateStatusSmartPayment: EventEmitter<any> = new EventEmitter();
  @Output('cryptoPayment') cryptoPayment: EventEmitter<any> =
    new EventEmitter();
  @Output('updateStatusSetAppointment')
  UpdateStatusSetAppointment: EventEmitter<any> = new EventEmitter();
  @Output('updateStatusWaiting') updateStatusWaiting: EventEmitter<any> =
    new EventEmitter();
  @Output('purchaseByWallet') purchaseByWallet: EventEmitter<any> =
    new EventEmitter();
  @Output('updatePayeerSellingStatus')
  updatePayeerSellingStatus: EventEmitter<any> = new EventEmitter();
  @Output('updateFreeOrder') updateFreeOrder: EventEmitter<any> =
    new EventEmitter();
  @Output('purchase') purchase: EventEmitter<any> = new EventEmitter();
  @Input() isValidRules: boolean;
  @Output() isValidRulesChange = new EventEmitter<boolean>();
  rechargeValue: number = 0;
  url: string;
  dataUser: UserProfile = new UserProfile();

  constructor(
    private _alert: AlertHelper,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    private _userStore: UserStore
  ) {}

  acceptAlarmBeforePay() {
    this.confirmationService.confirm({
      acceptLabel: 'متوجه شدم',
      message:
        this._translateService.translations[this._translateService.currentLang][
          'acceptRoleAppFee'
        ],
      rejectVisible: false,
      header: 'توجه',
      key: 'feeRole',
      accept: () => {
        this.submit();
      },
    });
  }

  getUserStore() {
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
      }
    });
  }

  submit() {
    if (this.payType == '422') {
      this.updateStatusDocument.emit();
    } else if (this.payType == '431') {
      this.updateStatusSmartPayment.emit();
    } else if (this.payType == '429') {
      this.updateStatusWaiting.emit();
    } else if (this.payType == '427') {
      this.UpdateStatusSetAppointment.emit();
    } else if (this.payType == '430') {
      this.cryptoPayment.emit();
    } else if (
      ((this.payType == '421' ||
        this.payType == '423' ||
        this.payType == '425') &&
        this.dataCheckout.discount &&
        this.dataCheckout.discount > 0 &&
        this.dataCheckout.discountedFinalAmount >= 1000) ||
      ((this.payType == '421' ||
        this.payType == '423' ||
        this.payType == '425') &&
        !this.dataCheckout.discount &&
        this.dataCheckout.finalAmount >= 1000)
    ) {
      this.purchase.emit();
    } else if (
      (this.payType == '426' &&
        this.dataCheckout.discount &&
        this.dataCheckout.discount > 0 &&
        this.dataCheckout.discountedFinalAmount >= 1000) ||
      (this.payType == '426' &&
        !this.dataCheckout.discount &&
        this.dataCheckout.finalAmount >= 1000)
    ) {
      this.purchaseByWallet.emit();
    } else if (this.payType == '428' && this.orderType == 906) {
      this.updatePayeerSellingStatus.emit();
    } else {
      this.updateStatusWaiting.emit();
    }
    this.isValidRulesChange.emit(true);
  }

  buttonClickActions(checkedRole) {
    if (!checkedRole) {
      this._alert.warning(
        this._translateService.translations[this._translateService.currentLang][
          'read&AcceptRules'
        ],
      );
      return;
    }
    if (this.payType == '426' && this.isDisabledWallet) {
      this.getUserStore();
      this.confirmStatusPayByWallet();
    }
  }

  confirmStatusPayByWallet() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'payByWalletNotEnoughInvertory'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'notEnoughExistance'
        ],
      key: 'notEnoughInvertoryWallet',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'walletRecharge'
        ],
      rejectLabel:
        this._translateService.translations[this._translateService.currentLang][
          'changePaymentMethod'
        ],
      acceptIcon: 'none',
      rejectIcon: 'none',
      accept: () => {
        this.walletRecharge();
      },
    });
  }

  walletRecharge() {
    if (
      this.dataUser != undefined &&
      this.dataCheckout != undefined &&
      this.dataUser != null &&
      this.dataCheckout != null &&
      this.dataUser.amountWallet < this.dataCheckout.finalAmount
    ) {
      if (this.dataCheckout.discountedFinalAmount) {
        this.rechargeValue =
          this.dataCheckout.discountedFinalAmount - this.dataUser.amountWallet;
      } else {
        this.rechargeValue =
          this.dataCheckout.finalAmount - this.dataUser.amountWallet;
      }
    }
    const ref = this.dialogService.open(WalletRechargeComponent, {
      header:
        this._translateService.translations[this._translateService.currentLang][
          'walletRecharge'
        ],
      height: '70%',
      width: '40%',
      styleClass: 'wallet-modal',
      closeOnEscape: true,
      dismissableMask: true,
      data: {
        value: this.rechargeValue,
        url: this.url,
      },
    });
    ref.onClose.subscribe((model: any) => {});
  }
}
