import { AuthGuard } from 'src/app/core/guards/Auth.guard';
import { HttpClientModule, HTTP_INTERCEPTORS } from '@angular/common/http';
import {
  APP_INITIALIZER,
  ErrorHandler,
  NgModule,
  Optional,
  SkipSelf,
} from '@angular/core';
import { MessageService, PrimeNGConfig } from 'primeng/api';
import { CommonModule } from '@angular/common';
import { ConstantService } from '@services/constant.service';
import { CommonService } from '@services/common.service';
import { PagingHelper } from '@helpers/paging.helper';
import { AlertHelper } from '@helpers/alert.helper';
import { UserStore } from './stores/user.store';
import { JWTInterceptor } from '@interceptors/jwt.interceptor';
import { AuthErrorInterceptor } from '@interceptors/authError.Interceptor';
import { ApiPrefixInterceptor } from '@interceptors/apiPrefix.interceptor';
import { TitleService } from '@services/title.service';
import { primeTranslate } from '@constants/primeTranslate.constant';
import { StyleStore } from '@stores/style.store';
import { SignalrService } from '@services/signalr.service';
import { TranslateService } from '@ngx-translate/core';
import { DetectHelper } from '@helpers/detectHelper';
import { FileUploadService } from '@services/fileUpload.service';
import { ErrorServices } from '@services/errors.service';
import { GoogleTagManagerEventService } from '@services/googleTagManagerEvent.service';
import { AppSettingsService } from '@services/app.settings.service';
import { LanguagesService } from '@services/languages.service';
import { TranslateHelper } from '@helpers/translate.helper';
import { RedirectorHelper } from '@helpers/redirector.helper';
import { BlockStore } from '@stores/blockOrder';
import { FileUrlGeneratorStore } from '@stores/fileUrlGenerator.store';
export function initConstant(config: ConstantService) {
  return () => {
    return config.load();
  };
}

export function initLanguages(data: LanguagesService) {
  return () => {
    return data.load();
  };
}
@NgModule({
  declarations: [],
  imports: [HttpClientModule, CommonModule],
  exports: [],

  providers: [
    ConstantService,
    {
      provide: APP_INITIALIZER,
      useFactory: initConstant,
      multi: true,
      deps: [ConstantService],
    },

    LanguagesService,
    {
      provide: APP_INITIALIZER,
      useFactory: initLanguages,
      multi: true,
      deps: [LanguagesService],
    },
    CommonService,
    AppSettingsService,
    AlertHelper,
    UserStore,
    StyleStore,
    FileUrlGeneratorStore,
    BlockStore,
    SignalrService,
    TranslateHelper,
    GoogleTagManagerEventService,
    TitleService,
    { provide: HTTP_INTERCEPTORS, useClass: ApiPrefixInterceptor, multi: true },
    { provide: HTTP_INTERCEPTORS, useClass: JWTInterceptor, multi: true },
    { provide: HTTP_INTERCEPTORS, useClass: AuthErrorInterceptor, multi: true },
    PagingHelper,
    AuthGuard,
    FileUploadService,
    MessageService,
    DetectHelper,
    RedirectorHelper,
    TranslateService,
    {
      provide: ErrorHandler,
      useClass: ErrorServices,
    },
  ],
})

export class CoreModule {
  constructor(
    @Optional()
    @SkipSelf()
    parentModule: CoreModule,
    titleService: TitleService,
    private primengConfig: PrimeNGConfig
  ) {
    if (parentModule) {
      throw new Error(
        'CoreModule is already loaded. Import it in the AppModule only.'
      );
    }
    this.primengConfig.ripple = true;
    this.primengConfig.setTranslation(Object.assign(primeTranslate));

    titleService.init();
  }
}
