import { Injectable } from '@angular/core';
import { RouterStateSnapshot, ActivatedRouteSnapshot, CanActivate } from '@angular/router';
import { Router } from '@angular/router';
import { ColumnKey } from '@enums/columnKey.enum';
import { getStorageItem } from '@helpers/localstorage.helper';
@Injectable()
export class AuthGuard implements CanActivate {
  constructor(private router: Router) { }
  canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot): boolean {
    const tokenStr = getStorageItem(ColumnKey.UserToken);
    if (!tokenStr) {
      this.router.navigate(['/login'], {
        queryParams: { returnUrl: state.url },
      });
      return false;
    }
    try {
      const token = JSON.parse(tokenStr);

      if (token?.access_token) {
        return true;
      }
    } catch (e) {
    }
    this.router.navigate(['/login'], {
      queryParams: { returnUrl: state.url },
    });
    return false;
  }

}
