import { Injectable } from '@angular/core';
import { MessageService } from 'primeng/api';

@Injectable()
export class AlertHelper {
  constructor(private messageService: MessageService) {}

  success(message: string) {
    this.messageService.add({
      severity: 'success',
      summary: ' ',
      detail: message,
      life: 8000,
    });
  }
  
  info(message: string) {
    this.messageService.add({
      severity: 'info',
      summary: ' ',
      detail: message,
      life: 8000,
    });
  }

  error(message: string) {
    this.messageService.add({
      severity: 'error',
      summary: ' ',
      detail: message,
      life: 8000,
    });
  }

  warning(message: string) {
    this.messageService.add({
      severity: 'warn',
      summary: ' ',
      detail: message,
      life: 8000,
    });
  }
}
