export function toEnglishDigits(input: any): string {
  if (input == null) return '';
  input = String(input);

  const persianDigits = '۰۱۲۳۴۵۶۷۸۹';
  const arabicDigits = '٠١٢٣٤٥٦٧٨٩';

  return input.replace(/[۰-۹٠-٩]/g, (char) => {
    const index = persianDigits.indexOf(char);
    if (index > -1) return index.toString();
    return arabicDigits.indexOf(char).toString();
  });
}
