import { ColumnKey } from "@enums/columnKey.enum";

export const getCookieItem = (itemName: string): string | null => {
    if (typeof document === 'undefined') return null;
  
    const cookies = document.cookie ? document.cookie.split('; ') : [];
  
    const cookie = cookies.find(row => row.startsWith(`${itemName}=`));
    if (!cookie) return null;
  
    const value = cookie.split('=')[1];
    return decodeURIComponent(value);
  };