import { Injectable } from '@angular/core';
import { BehaviorSubject, interval, Subscription } from 'rxjs';

@Injectable({ providedIn: 'root' })
export class CountdownService {
  private startTime!: number;
  private timerSub!: Subscription;

  public timer1$ = new BehaviorSubject<number>(120);

  public timer2$ = new BehaviorSubject<number>(60);

  startTimers() {
    this.startTime = Date.now();
    this.timerSub = interval(1000).subscribe(() => {
      const elapsedSeconds = Math.floor((Date.now() - this.startTime) / 1000);

      const remainingTimer1 = Math.max(0, 120 - elapsedSeconds);
      const remainingTimer2 = Math.max(0, 60 - elapsedSeconds);

      this.timer1$.next(remainingTimer1);
      this.timer2$.next(remainingTimer2);

      if (remainingTimer1 <= 0 && remainingTimer2 <= 0) {
        this.stopTimers();
      }
    });
  }

  stopTimers() {
    if (this.timerSub) {
      this.timerSub.unsubscribe();
    }
  }
}
