import { environment } from 'src/environments/environment';
import { Static } from './../interfaces/static';
import configuration from '@config/config.json';
export const getImportance = (
  hasAll: boolean = false,
  find: number = null
): Static[] | null => {
  let data = [
    { id: 200031, title: 'پايين' },
    { id: 200032, title: 'معمولي' },
    { id: 200033, title: 'بالا' },
  ];
  if (hasAll) data.unshift({ id: 0, title: 'همه' });
  return data;
};

/****
 * جنسیت
 */
export const getGender = (
  hasAll: boolean = false,
  find: number = null
): Static[] | null => {
  let data = [
    { id: 200011, title: 'آقا' },
    { id: 200012, title: 'خانم' },
  ];
  if (hasAll) data.unshift({ id: -1, title: 'همه' });
  return data;
};

/****
 * وضعیت تیکت
 */
export const getStatus = (
  hasAll: boolean = false,
  find: number = null
): Static[] | null => {
  let data = [
    { id: 200021, title: 'باز' },
    { id: 200022, title: 'درحال پيگيري' },
    { id: 200023, title: 'پاسخ داده شده' },
    { id: 200024, title: 'بسته' },
    { id: 200025, title: 'بايگاني' },
    { id: 200026, title: 'در انتظار پاسخ' },
  ];
  if (hasAll) data.unshift({ id: -1, title: 'همه' });
  return data;
};

export const getMonth = (
  hasAll: boolean = false,
  find: number = null
): Static[] | null => {
  let data = [
    { id: 1, title: 'فروردین' },
    { id: 2, title: 'اردیبهشت' },
    { id: 3, title: 'خرداد' },
    { id: 4, title: 'تیر' },
    { id: 5, title: 'مرداد' },
    { id: 6, title: 'شهریور' },
    { id: 7, title: 'مهر' },
    { id: 8, title: 'آبان' },
    { id: 9, title: 'آذر' },
    { id: 10, title: 'دی' },
    { id: 11, title: 'بهمن' },
    { id: 12, title: 'اسفند' },
  ];
  if (hasAll) data.unshift({ id: -1, title: 'همه' });
  return data;
};


export const getConfigCarouselOWL = (): any => {
  let responsive = {
    loop: false,
    margin: 10,
    autoplay: true,
    autoplayTimeout: 3000,
    autoplaySpeed: 500,
    dots: true,
    autoWidth: true,
    rewind: true,
    responsiveClass: true,
    responsive: {
      0: {
        items: 1,
        loop: false,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        rewind: true,
      },
      600: {
        items: 3,
        loop: false,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        rewind: true,
      },
      1024: {
        items: 5,
        loop: false,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        rewind: true,
      },
      1200: {
        items: 5,
        loop: false,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        rewind: true,
      },
      2000: {
        items: 5,
        loop: false,
        margin: 0,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        rewind: true,
      },
    },
  };
  return responsive;
};

export const getConfigCarouselOWLTopSticky = (): any => {
  let responsive = {
    singleItem: true,
    loop: true,
    autoWidth: false,
    autoplay: true,
    autoplayTimeout: 3000,
    autoplaySpeed: 500,
    dots: true,
    slideBy: 'page',
    center: true,
    margin: 10,
    lazyLoad: true,

    responsiveClass: true,
    responsive: {
      0: {
        singleItem: true,
        slideBy: 'page',
        items: 1,
        loop: true,
        autoWidth: false,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        center: true,
        margin: 10,
        lazyLoad: true
      },
      600: {
        singleItem: true,
        slideBy: 'page',
        items: 1,
        loop: true,
        autoWidth: false,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        center: true,
        margin: 10, lazyLoad: true
      },
      1024: {
        singleItem: true,
        slideBy: 'page',
        items: 1,
        loop: true,
        autoWidth: false,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        center: true,
        margin: 10, lazyLoad: true
      },
      1200: {
        singleItem: true,
        slideBy: 'page',
        items: 1,
        loop: true,
        autoWidth: false,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        center: true,
        margin: 10, lazyLoad: true
      },
      2000: {
        singleItem: true,
        slideBy: 'page',
        items: 1,
        loop: true,
        autoWidth: false,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplaySpeed: 500,
        dots: true,
        center: true,
        margin: 10, lazyLoad: true
      }
    },
  };
  return responsive;
};
