import { Injectable } from '@angular/core';
import { stringIsEmptyOrNull } from './validator.helper';
import { BaseParams } from '../params/user/baseParams';

@Injectable()
export class PagingHelper {
  constructor() {}
  requestParamsSet(event: any = null, query: BaseParams): any {
    if (event != null) {
      query = this.filterSet(event['filters'], query);
      query.sort = this.sortSet(event['sortField'], event['sortOrder']);
      query.pageSize = event['rows'];
      query.startIndex = this.pageNumber(event['first'], query['pageSize']);
    }
    return query;
  }
  rowIndex(query: BaseParams, index: number): number {
    return index + 1;
  }
  pageNumber(indexNumber: number, pageSize: number): number {
    return indexNumber / pageSize + 1;
  }
  indexNumber(pageNumber: number, pageSize: number): number {
    return (pageNumber - 1) * pageSize;
  }
  filterSet(filters: any, query: any): any {
    if (filters != undefined && filters != null) {
      for (let item in filters) {
        if (
          filters[item] != undefined &&
          filters[item] != null &&
          filters[item][0] != undefined &&
          filters[item][0].value != undefined
        ) {
          query[item] = filters[item][0].value;
        }
      }
    }
    return query;
  }
  sortSet(field: string, order: number): string {
    if (!stringIsEmptyOrNull(field)) {
      if (order === 1) {
        field = field + ' asc';
      } else if (order === -1) {
        field = field + ' desc';
      }
      return field;
    }
    return '';
  }
  firstRecord(query: BaseParams): number {
    return 1 + query.pageSize * query.startIndex - query.pageSize;
  }
  lastRecord(query: BaseParams, totalRecords: number): number {
    if (totalRecords - this.firstRecord(query) + query.pageSize > 0) {
      return this.firstRecord(query) + query.pageSize;
    } else {
      return totalRecords;
    }
  }
  isFirstPage(query: BaseParams): boolean {
    return this.firstRecord(query) === 1;
  }
  isLastPage(query: BaseParams, totalRecords: number): boolean {
    return totalRecords - this.lastRecord(query, totalRecords) <= 0;
  }
  rowsPersPage(): number[] {
    return [10, 25, 50];
  }
}
