import { Injectable } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { stringIsEmptyOrNull } from './validator.helper';
@Injectable()
export class RedirectorHelper {
  constructor(
    private _activatedRoute: ActivatedRoute,
    private _router: Router
  ) {}

  routerHandlerAuth(routeName: string) {
    if (stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language'])) {
      if (
        stringIsEmptyOrNull(
          this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        )
      ) {
        this._router.navigateByUrl('/' + routeName);
      } else {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '?returnUrl=' +
            this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        );
      }
    } else {
      if (
        stringIsEmptyOrNull(
          this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        )
      ) {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '/' +
            this._activatedRoute.snapshot.params['language']
        );
      } else {
        this._router.navigateByUrl(
          '/' +
            routeName +
            '/' +
            this._activatedRoute.snapshot.params['language'] +
            '?returnUrl=' +
            this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
        );
      }
    }
  }

  routerHandlerAfterAuth() {
    if (
      stringIsEmptyOrNull(
        this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
      )
    ) {
      if (
        stringIsEmptyOrNull(this._activatedRoute.snapshot.params['language'])
      ) {
        this._router.navigate(['/dashboard']);
      } else
        this._router.navigate([
          '/dashboard/home/' + this._activatedRoute.snapshot.params['language'],
        ]);
    } else
      this._router.navigateByUrl(
        this._activatedRoute.snapshot.queryParamMap.get('returnUrl')
      );
  }
}
