import { Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
@Injectable()
export class TranslateHelper {
  constructor(private translateService: TranslateService) { }
  rtlLtr(language: string): void {
    const dom: any = document.querySelector('body');
    if (language == 'en') {
      dom.classList.remove('font-persian');
      this.translateService.use('en');
      dom.classList.add('font-english');
    } else {
      dom.classList.remove('font-english');
      this.translateService.use('fa');
      dom.classList.add('font-persian');
    }
  }

  ordinaryNumberToAlphabetic(ordinaryNumber: number) {
    switch (ordinaryNumber) {
      case 1:
        return 'اولین';

      case 2:
        return 'دومین';

      case 3:
        return 'سومین';

      case 4:
        return 'چهارمین';
      default:
        return null;
    }
  }

  ceilOrFloorOfNumberConvert(value: number) {

    let floatPortion;

    floatPortion = parseFloat(
      value.toString().substring(value.toString().indexOf('.') + 1)
    );

    if (floatPortion.toString()[0] >= 5) {
      value = Math.ceil(value);
    } else {
      value = Math.floor(value);
    }

    value = Number(value)
    return value;

  }
}
