

export const getPath = (): string | null => {
    var pathList = window.location.href.replace('http://', '').replace('https://', '').split('/');
    let index = 0;
    let path = '';
    for (let item of pathList) {
        if (index != 0) {
            path = path + '/' + item;
        }
        index++;
    }
    return path;
};

export const getParameterByName = (name, url = window.location.href): string | null => {
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}