export const stringIsEmptyOrNull = (value: string): boolean => {
  if (
    value === undefined ||
    value === 'undefined' ||
    value === null ||
    value === 'null' ||
    value === ''
  ) {
    return true;
  } else {
    return false;
  }
};

export const isInteger = (value: string | number): boolean => {
  return (
    value != undefined &&
    value != null &&
    value !== '' &&
    !isNaN(Number(value.toString()))
  );
};

export const fieldIsNotNull = (object: any, key: string): boolean => {
  if (
    object != undefined &&
    object != null &&
    typeof object === 'object' &&
    key != undefined &&
    key != null &&
    key != ''
  ) {
    if (key in object && object[key] != undefined && object[key] != null) {
      return true;
    }
  }
  return false;
};

export const isObject = (object: any): boolean => {
  return object instanceof Object;
};

export function isUrlValid(url: string): boolean {
  if (!url || typeof url !== 'string') return false;

  const pattern = /^(?:(https?|ftp):\/\/)?(www\.)?([a-z0-9-]+\.)+[a-z]{2,}(\/[^\s]*)?$/i;
  return pattern.test(url.trim());
}

export const isGuid = (value: string): boolean => {
  if (stringIsEmptyOrNull(value)) return false;
  let checkValue = value.match(
    '^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$'
  );
  if (checkValue === null) {
    return false;
  }
  return true;
};

export const isStrong = (value: string): boolean => {
  if (stringIsEmptyOrNull(value)) return false;
  let checkValue = value.match('^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.{8,})');
  if (checkValue === null) {
    return false;
  }
  return true;
};

export const isValidEmail = (email): any => {
  if (stringIsEmptyOrNull(email)) return false;
  return String(email)
    .toLowerCase()
    .match(
      /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
    );
};

export const isValidMobile = (mobile): any => {
  let phoneRegex = /^\+?[0-9]\d{1,14}$/;
  if (stringIsEmptyOrNull(mobile)) return false;
  return String(mobile).toLowerCase().match(phoneRegex);
};

export const isArabic = (value: any): boolean => {
  var isArabic = /[\u0600-\u06FF\u0750-\u077F]/;
  return isArabic.test(value);
};
