import { Address } from '@enums/address.enum';
import { Static } from '@interfaces/static';

export const genders = (all: boolean = false): Static | any => {
  var data = [
    { id: 131, title: 'آقا' },
    { id: 132, title: 'خانم' },
  ];
  if (all) data.unshift({ id: -1, title: 'همه' });
  return data;
};

export const statusTypes = (all: boolean = false): Static | any => {
  var data = [
    { id: 181, title: 'پيش فاکتور' },
    { id: 182, title: 'پرداخت شده' },
    { id: 183, title: 'در حال بررسي' },
    { id: 184, title: 'تاييد شده' },
    { id: 185, title: 'در حال پردازش' },
    { id: 186, title: 'پرداخت شده' },
    { id: 187, title: 'لغو شده' },
    { id: 188, title: 'در انتظار ارسال فيش پرداختي' },
  ];
  if (all) data.unshift({ id: -1, title: 'همه' });
  return data;
};

export const getDepositOptions = (): Static[] | null => {
  let data = [
    { id: 1, title: 'بارگذاری سند واریزی' },
  ];
  return data;
};

export const getPublicDepositOptions = (): Static[] | null => {
  let data = [
    { id: 1, title: 'ثبت فاکتور انتقال ارز' },
    { id: 2, title: 'ثبت کد تراکنش' },
  ];
  return data;
};

export const getTicketStatus = (): Static[] | null => {
  let data = [
    { id: -1, title: 'همه' },
    { id: 201, title: 'باز' },
    { id: 202, title: 'در حال پیگیری' },
    { id: 203, title: 'پاسخ داده شده ' },
    { id: 204, title: 'در انتظار پاسخ ' },
    { id: 205, title: 'بسته ' },
    { id: 207, title: 'تیکت خودکار' },
    { id: 208, title: 'پیام کارشناس ' },
    { id: 206, title: 'بایگانی شده ' },
  ];
  return data;
};

export const getOnlinePortPayApi = (value: string | number): string | null => {
  switch (value) {
    case '452':
    case 452:
      return Address.TransActionStartPayJibit;

    case '453':
    case 453:
      return Address.TransActionStartPayVandar;

    case '454':
    case 454:
      return Address.TransActionStartPayShepa;

    case '455':
    case 455:
      return Address.TransactionStartPayZarin;

    case '457':
    case 457:
      return Address.TransactionStartPayZarinLink;

    case '458':
    case 458:
      return Address.TransactionStartPaySepal;

    default:
      return null;
  }
};
