import { Injectable } from "@angular/core";
import {
  HttpRequest,
  HttpHandler,
  HttpEvent,
  HttpInterceptor, HttpHeaders, HttpResponse
} from '@angular/common/http';
import { Observable } from 'rxjs';
import { Router } from "@angular/router";
import { tap } from 'rxjs/operators';
import { getStorageItem } from '../helpers/localstorage.helper';
import { ColumnKey } from '../enums/columnKey.enum';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Injectable()
export class JWTInterceptor implements HttpInterceptor {
  constructor(private router: Router) {

  }

  intercept(request: HttpRequest<unknown>, next: HttpHandler): Observable<HttpEvent<unknown>> {
    let interceptedReq;
    let accessToken = '';
    if (getStorageItem(ColumnKey.UserToken) != undefined && getStorageItem(ColumnKey.UserToken) != null) {
      const userAccount = JSON.parse(getStorageItem(ColumnKey.UserToken));

      if (userAccount != undefined && userAccount != null && !stringIsEmptyOrNull(userAccount.access_token)) {
        accessToken = userAccount.access_token;
      }
    }
    if (!stringIsEmptyOrNull(accessToken))
      interceptedReq = request.clone({
        headers: new HttpHeaders({ authorization: `Bearer ${accessToken}` }),
      });
    else
      interceptedReq = request.clone({
      });

    return next.handle(interceptedReq).pipe(
      tap(res => {
        if (res instanceof HttpResponse) {
        }
      })
    );


  }

}