import { Injectable } from '@angular/core';
import {
    HttpInterceptor,
    HttpRequest,
    HttpHandler,
    HttpEvent,
} from '@angular/common/http';
import { Observable } from 'rxjs';
import { tap } from 'rxjs/operators';

@Injectable()
export class NetworkSpeedInterceptor implements HttpInterceptor {
    intercept(
        req: HttpRequest<any>,
        next: HttpHandler
    ): Observable<HttpEvent<any>> {
        const startTime = Date.now();
        return next.handle(req).pipe(
            tap({
                next: () => {
                    const endTime = Date.now();
                    const duration = endTime - startTime;
                    if (duration > 2000) {
                        console.warn('Slow network detected:', duration, 'ms');
                    }
                },
            })
        );
    }
}
