import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'cardNumber',
})
export class CardNumberPipe implements PipeTransform {
  constructor() {}
  transform(value: string, isDash: boolean) {
    if (value) {
      let newValue = '';
      if (value.length == 16) {
        newValue =
          value.substring(0, 4) +
          ' &nbsp ' +
          value.substring(4, 8) +
          ' &nbsp ' +
          value.substring(8, 12) +
          ' &nbsp ' +
          value.substring(12, 16);
      }

      if (isDash == false) {
        newValue =
          value.substring(0, 4) +
          ' &nbsp ' +
          value.substring(4, 8) +
          ' &nbsp ' +
          value.substring(8, 12) +
          ' &nbsp ' +
          value.substring(12, 16);
      }
      if (isDash == true) {
        newValue =
          value.substring(0, 4) +
          ' - ' +
          value.substring(4, 8) +
          ' - ' +
          value.substring(8, 12) +
          ' - ' +
          value.substring(12, 16);
      }

      value = newValue;
    }

    return value;
  }
}
