import { Pipe, PipeTransform } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';

@Pipe({
  name: 'priceTypePipe',
})
export class PriceTypePipe implements PipeTransform {
  constructor(private translate: TranslateService) {}

  transform(
    price: string | number | null | undefined,
    type: number,
    showZeroInsteadOfFree?: boolean,
    forceShowAmount?: boolean
  ): string {
    const raw = price === null || price === undefined ? '' : String(price);
    const cleaned = raw.replace(/[^\d.-]/g, '');

    if (cleaned === '') {
      return showZeroInsteadOfFree
        ? '0'
        : this.translate.translations[this.translate.currentLang]['free'];
    }

    const numeric = Number(cleaned);
    if (isNaN(numeric)) {
      return showZeroInsteadOfFree
        ? '0'
        : this.translate.translations[this.translate.currentLang]['free'];
    }

    const isFree = !forceShowAmount && (numeric === 0 || numeric < 1000);
    if (isFree) {
      return showZeroInsteadOfFree
        ? '0'
        : this.translate.translations[this.translate.currentLang]['free'];
    }

    const priceStr = String(price);
    const t = this.translate.translations[this.translate.currentLang];

    switch (type) {
      case 0:
        return priceStr + ' ' + t['toman'];
      case 1:
        return priceStr + ' ' + t['dollar'];
      case 2:
        return t['euro'] + ' ' + priceStr;
      case 3:
        return t['rial'] + ' ' + priceStr;
      case 4:
        return t['lira'] + ' ' + priceStr;
      default:
        return priceStr;
    }
  }
}
