import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'transactionUnit',
})
export class TransactionUnitPipe implements PipeTransform {
  transform(value: any, item: any): string {
    if (value == null) return '-';

    let stringValue = value.toString();

    stringValue = stringValue.replace(/\B(?=(\d{3})+(?!\d))/g, '٬');

    return `${stringValue} تومان`;
  }
}
