import { Injectable } from '@angular/core';
import Clarity from '@microsoft/clarity';
import configuration from '@config/config.json';
@Injectable({
  providedIn: 'root'
})
export class ClarityService {
  private initialized = false;
  private readonly projectId = configuration.clarityId;

  init(): void {
    if (this.initialized || typeof window === 'undefined') return;
    Clarity.init(this.projectId);
    this.initialized = true;
  }

  identify(userId: string, sessionId?: string, pageId?: string, name?: string): void {
    Clarity.identify(userId, sessionId, pageId, name);
  }

  tag(key: string, value: string | string[]): void {
    Clarity.setTag(key, value);
  }

  event(name: string): void {
    Clarity.event(name);
  }

  consent(granted = true): void {
    Clarity.consent(granted);
  }

  upgrade(reason: string): void {
    Clarity.upgrade(reason);
  }
}
