import { HttpClient } from '@angular/common/http';
import { ErrorHandler, Injectable } from '@angular/core';
import { Address } from '@enums/address.enum';
import { cloneDeep } from 'lodash-es';
import { finalize, Observable } from 'rxjs';
import { response } from '@interfaces/response';

import Clarity from '@microsoft/clarity';

@Injectable()
export class ErrorServices implements ErrorHandler {
  constructor(private _http: HttpClient) {}

  handleError(error: any) {
    const err = {
      message: error?.message ?? error?.toString(),
      stack: error?.stack ?? '',
      timestamp: new Date().toISOString(),
      userAgent: navigator.userAgent,
      url: window.location.href,
    };

    // ثبت در سرور خودت
    this.post(err)
      .pipe(finalize(() => {}))
      .subscribe(
        (response: response) => {},
        (error) => {}
      );

    try {
      if (typeof Clarity !== 'undefined') {
        Clarity.event('global_error');
        (window as any).clarity?.('set', 'last_error_message', err.message);
        (window as any).clarity?.('set', 'error_url', err.url);
      }
    } catch (e) {
      console.warn('Clarity error tracking failed:', e);
    }

    console.error('Global Error:', err);
  }

  post(data: any): Observable<any> {
    let body = cloneDeep(data);
    return this._http.post<any>(Address.LogUI, body);
  }
}
