import { Injectable } from '@angular/core';
import { GoogleTagManagerService } from 'angular-google-tag-manager';
@Injectable()
export class GoogleTagManagerEventService {

  constructor(private gtmService: GoogleTagManagerService) { }

  setClick(eventName: string) {
    const gtmTag = {
      event: 'click',
      data: eventName,
    };
    this.gtmService.pushTag(gtmTag);
  }
  getClientId(){
    const gaCookie = document.cookie.split('; ').find(row => row.startsWith('_ga='));
    const clientId = gaCookie?.split('.').slice(2).join('.');
    return clientId;
  }
}
