import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
 @Injectable()
export class LanguagesService {
  constructor(private http: HttpClient) {}
  private data: any = null;
  get languages() {
    return this.getProperty('data');
  }
 
  load(): Promise<any> {
    let filejson ='languages';
    const promise = this.http
      .get(`./constant/${filejson}.json`)
      .toPromise()
      .then((res) => {
        this.data = res;
      })
      .catch((err) => {
        console.log('error',err);
      });
    return promise;
  }

 
  private getProperty(property: string): any {
    if (!this.data) {
      throw new Error(
        'Attempted to access configuration property before configuration data was loaded, please implemented.'
      );
    }

    if (!this.data[property]) {
      throw new Error(`Required property ${property} was not defined within the configuration object. Please double check the
        connect-server.json file`);
    }

    return this.data[property];
  }
}
